/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.phonenumberlookup.controllers;

import com.bandwidth.ApiHelper;
import com.bandwidth.AuthManager;
import com.bandwidth.Configuration;
import com.bandwidth.Server;
import com.bandwidth.controllers.BaseController;
import com.bandwidth.exceptions.ApiException;
import com.bandwidth.http.Headers;
import com.bandwidth.http.client.HttpCallback;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpContext;
import com.bandwidth.http.request.HttpBodyRequest;
import com.bandwidth.http.request.HttpRequest;
import com.bandwidth.http.response.ApiResponse;
import com.bandwidth.http.response.HttpResponse;
import com.bandwidth.http.response.HttpStringResponse;
import com.bandwidth.phonenumberlookup.exceptions.AccountsTnlookup400ErrorException;
import com.bandwidth.phonenumberlookup.models.OrderRequest;
import com.bandwidth.phonenumberlookup.models.OrderResponse;
import com.bandwidth.phonenumberlookup.models.OrderStatus;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class APIController
extends BaseController {
    public APIController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public APIController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    public ApiResponse<OrderResponse> createLookupRequest(String accountId, OrderRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateLookupRequestRequest(accountId, body);
        ((AuthManager)this.authManagers.get("phoneNumberLookup")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateLookupRequestResponse(context);
    }

    public CompletableFuture<ApiResponse<OrderResponse>> createLookupRequestAsync(String accountId, OrderRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateLookupRequestRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("phoneNumberLookup")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateLookupRequestResponse(context));
    }

    private HttpRequest buildCreateLookupRequestRequest(String accountId, OrderRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.PHONENUMBERLOOKUPDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/tnlookup");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<OrderResponse> handleCreateLookupRequestResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new AccountsTnlookup400ErrorException("Bad Request. Ensure that your request payload is properly formatted and that the telephone numbers used are valid.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Unauthorized. Ensure that you are using the proper credentials for the environment you are accessing, your user has the proper role assigned to it, and that your Bandwidth account is enabled for TN Lookup access.", context);
        }
        if (responseCode == 415) {
            throw new ApiException("Invalid content-type. Ensure that your content-type header is set to application/json.", context);
        }
        if (responseCode == 429) {
            throw new ApiException("Too Many Requests. Reduce the amount of requests that you are sending in order to avoid receiving this status code.", context);
        }
        if (responseCode == 500) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 501) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 502) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 503) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 504) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 505) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 506) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 507) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 508) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 509) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 510) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 511) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 512) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 513) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 514) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 515) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 516) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 517) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 518) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 519) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 520) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 521) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 522) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 523) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 524) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 525) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 526) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 527) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 528) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 529) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 530) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 531) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 532) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 533) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 534) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 535) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 536) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 537) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 538) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 539) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 540) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 541) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 542) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 543) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 544) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 545) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 546) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 547) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 548) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 549) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 550) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 551) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 552) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 553) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 554) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 555) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 556) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 557) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 558) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 559) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 560) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 561) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 562) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 563) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 564) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 565) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 566) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 567) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 568) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 569) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 570) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 571) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 572) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 573) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 574) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 575) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 576) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 577) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 578) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 579) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 580) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 581) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 582) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 583) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 584) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 585) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 586) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 587) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 588) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 589) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 590) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 591) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 592) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 593) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 594) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 595) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 596) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 597) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 598) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 599) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        OrderResponse result = ApiHelper.deserialize(responseBody, OrderResponse.class);
        return new ApiResponse<OrderResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<OrderStatus> getLookupRequestStatus(String accountId, String requestId) throws ApiException, IOException {
        HttpRequest request = this.buildGetLookupRequestStatusRequest(accountId, requestId);
        ((AuthManager)this.authManagers.get("phoneNumberLookup")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetLookupRequestStatusResponse(context);
    }

    public CompletableFuture<ApiResponse<OrderStatus>> getLookupRequestStatusAsync(String accountId, String requestId) {
        return this.makeHttpCallAsync(() -> this.buildGetLookupRequestStatusRequest(accountId, requestId), req -> ((AuthManager)this.authManagers.get("phoneNumberLookup")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetLookupRequestStatusResponse(context));
    }

    private HttpRequest buildGetLookupRequestStatusRequest(String accountId, String requestId) {
        String baseUri = this.config.getBaseUri(Server.PHONENUMBERLOOKUPDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/tnlookup/{requestId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("requestId", new AbstractMap.SimpleEntry<String, Boolean>(requestId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<OrderStatus> handleGetLookupRequestStatusResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiException("Bad Request. Ensure that you have set the requestId as a URL path parameter.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Unauthorized. Ensure that you are using the proper credentials for the environment you are accessing, your user has the proper role assigned to it, and that your Bandwidth account is enabled for TN Lookup access.", context);
        }
        if (responseCode == 404) {
            throw new ApiException("RequestId not found. Ensure that the requestId used in the URL path is valid and maps to a previous request that was submitted.", context);
        }
        if (responseCode == 429) {
            throw new ApiException("Too Many Requests. Reduce the amount of requests that you are sending in order to avoid receiving this status code.", context);
        }
        if (responseCode == 500) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 501) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 502) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 503) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 504) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 505) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 506) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 507) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 508) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 509) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 510) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 511) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 512) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 513) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 514) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 515) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 516) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 517) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 518) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 519) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 520) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 521) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 522) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 523) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 524) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 525) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 526) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 527) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 528) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 529) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 530) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 531) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 532) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 533) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 534) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 535) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 536) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 537) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 538) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 539) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 540) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 541) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 542) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 543) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 544) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 545) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 546) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 547) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 548) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 549) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 550) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 551) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 552) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 553) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 554) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 555) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 556) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 557) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 558) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 559) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 560) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 561) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 562) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 563) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 564) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 565) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 566) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 567) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 568) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 569) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 570) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 571) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 572) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 573) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 574) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 575) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 576) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 577) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 578) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 579) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 580) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 581) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 582) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 583) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 584) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 585) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 586) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 587) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 588) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 589) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 590) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 591) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 592) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 593) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 594) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 595) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 596) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 597) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 598) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        if (responseCode == 599) {
            throw new ApiException("Unexpected error. Please contact Bandwidth Support if your requests are receiving this status code for an extended period of time.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        OrderStatus result = ApiHelper.deserialize(responseBody, OrderStatus.class);
        return new ApiResponse<OrderStatus>(response.getStatusCode(), response.getHeaders(), result);
    }
}

