/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.bxml.verbs;

import com.bandwidth.voice.bxml.verbs.Method;
import com.bandwidth.voice.bxml.verbs.Verb;
import java.net.URI;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(name="Conference")
public class Conference
implements Verb {
    public static final String TYPE_NAME = "Conference";
    @XmlValue
    private String name;
    @XmlAttribute
    protected boolean mute;
    @XmlAttribute
    protected boolean hold;
    @XmlAttribute
    protected String callIdsToCoach;
    @XmlAttribute
    protected URI conferenceEventUrl;
    @XmlAttribute
    protected Method conferenceEventMethod;
    @XmlAttribute
    protected String username;
    @XmlAttribute
    protected String password;
    @XmlAttribute
    protected String fallbackUsername;
    @XmlAttribute
    protected String fallbackPassword;
    @XmlAttribute
    protected URI conferenceEventFallbackUrl;
    @XmlAttribute
    protected Method conferenceEventFallbackMethod;
    @XmlAttribute
    private String tag;

    Conference(String name, boolean mute, boolean hold, String callIdsToCoach, URI conferenceEventUrl, Method conferenceEventMethod, String username, String password, String fallbackUsername, String fallbackPassword, URI conferenceEventFallbackUrl, Method conferenceEventFallbackMethod, String tag) {
        this.name = name;
        this.mute = mute;
        this.hold = hold;
        this.callIdsToCoach = callIdsToCoach;
        this.conferenceEventUrl = conferenceEventUrl;
        this.conferenceEventMethod = conferenceEventMethod;
        this.username = username;
        this.password = password;
        this.fallbackUsername = fallbackUsername;
        this.fallbackPassword = fallbackPassword;
        this.conferenceEventFallbackUrl = conferenceEventFallbackUrl;
        this.conferenceEventFallbackMethod = conferenceEventFallbackMethod;
        this.tag = tag;
    }

    public static ConferenceBuilder builder() {
        return new ConferenceBuilder();
    }

    public static class ConferenceBuilder {
        private String name;
        private boolean mute;
        private boolean hold;
        private String callIdsToCoach;
        private URI conferenceEventUrl;
        private Method conferenceEventMethod;
        private String username;
        private String password;
        private String fallbackUsername;
        private String fallbackPassword;
        private URI conferenceEventFallbackUrl;
        private Method conferenceEventFallbackMethod;
        private String tag;

        public ConferenceBuilder conferenceEventUrl(String uri) {
            return this.conferenceEventUrl(URI.create(uri));
        }

        public ConferenceBuilder conferenceEventUrl(URI uri) {
            this.conferenceEventUrl = uri;
            return this;
        }

        public ConferenceBuilder conferenceEventMethod(String method) {
            return this.conferenceEventMethod(Method.fromValue(method));
        }

        public ConferenceBuilder conferenceEventMethod(Method method) {
            this.conferenceEventMethod = method;
            return this;
        }

        public ConferenceBuilder conferenceEventFallbackUrl(String uri) {
            return this.conferenceEventFallbackUrl(URI.create(uri));
        }

        public ConferenceBuilder conferenceEventFallbackUrl(URI uri) {
            this.conferenceEventFallbackUrl = uri;
            return this;
        }

        public ConferenceBuilder conferenceEventFallbackMethod(String method) {
            return this.conferenceEventFallbackMethod(Method.fromValue(method));
        }

        public ConferenceBuilder conferenceEventFallbackMethod(Method method) {
            this.conferenceEventFallbackMethod = method;
            return this;
        }

        public ConferenceBuilder callIdsToCoach(List<String> callIds) {
            this.callIdsToCoach = String.join((CharSequence)",", callIds);
            return this;
        }

        ConferenceBuilder() {
        }

        public ConferenceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConferenceBuilder mute(boolean mute) {
            this.mute = mute;
            return this;
        }

        public ConferenceBuilder hold(boolean hold) {
            this.hold = hold;
            return this;
        }

        public ConferenceBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ConferenceBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ConferenceBuilder fallbackUsername(String fallbackUsername) {
            this.fallbackUsername = fallbackUsername;
            return this;
        }

        public ConferenceBuilder fallbackPassword(String fallbackPassword) {
            this.fallbackPassword = fallbackPassword;
            return this;
        }

        public ConferenceBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Conference build() {
            return new Conference(this.name, this.mute, this.hold, this.callIdsToCoach, this.conferenceEventUrl, this.conferenceEventMethod, this.username, this.password, this.fallbackUsername, this.fallbackPassword, this.conferenceEventFallbackUrl, this.conferenceEventFallbackMethod, this.tag);
        }

        public String toString() {
            return "Conference.ConferenceBuilder(name=" + this.name + ", mute=" + this.mute + ", hold=" + this.hold + ", callIdsToCoach=" + this.callIdsToCoach + ", conferenceEventUrl=" + this.conferenceEventUrl + ", conferenceEventMethod=" + (Object)((Object)this.conferenceEventMethod) + ", username=" + this.username + ", password=" + this.password + ", fallbackUsername=" + this.fallbackUsername + ", fallbackPassword=" + this.fallbackPassword + ", conferenceEventFallbackUrl=" + this.conferenceEventFallbackUrl + ", conferenceEventFallbackMethod=" + (Object)((Object)this.conferenceEventFallbackMethod) + ", tag=" + this.tag + ")";
        }
    }
}

