/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.bxml.verbs;

import com.bandwidth.voice.bxml.verbs.AudioProducer;
import com.bandwidth.voice.bxml.verbs.Method;
import com.bandwidth.voice.bxml.verbs.PlayAudio;
import com.bandwidth.voice.bxml.verbs.SpeakSentence;
import com.bandwidth.voice.bxml.verbs.Verb;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Gather")
public class Gather
implements Verb {
    public static final String TYPE_NAME = "Gather";
    @XmlElements(value={@XmlElement(name="PlayAudio", type=PlayAudio.class), @XmlElement(name="SpeakSentence", type=SpeakSentence.class)})
    private List<AudioProducer> audioProducer;
    @XmlAttribute
    private URI gatherUrl;
    @XmlAttribute
    private Method gatherMethod;
    @XmlAttribute
    protected String username;
    @XmlAttribute
    protected String password;
    @XmlAttribute
    private String tag;
    @XmlAttribute
    private String terminatingDigits;
    @XmlAttribute
    private Integer maxDigits;
    @XmlAttribute
    private Double interDigitTimeout;
    @XmlAttribute
    private Double firstDigitTimeout;
    @XmlAttribute
    private Integer repeatCount;
    @XmlAttribute
    protected String fallbackUsername;
    @XmlAttribute
    protected String fallbackPassword;
    @XmlAttribute
    protected URI gatherFallbackUrl;
    @XmlAttribute
    protected Method gatherFallbackMethod;

    Gather(List<AudioProducer> audioProducer, URI gatherUrl, Method gatherMethod, String username, String password, String tag, String terminatingDigits, Integer maxDigits, Double interDigitTimeout, Double firstDigitTimeout, Integer repeatCount, String fallbackUsername, String fallbackPassword, URI gatherFallbackUrl, Method gatherFallbackMethod) {
        this.audioProducer = audioProducer;
        this.gatherUrl = gatherUrl;
        this.gatherMethod = gatherMethod;
        this.username = username;
        this.password = password;
        this.tag = tag;
        this.terminatingDigits = terminatingDigits;
        this.maxDigits = maxDigits;
        this.interDigitTimeout = interDigitTimeout;
        this.firstDigitTimeout = firstDigitTimeout;
        this.repeatCount = repeatCount;
        this.fallbackUsername = fallbackUsername;
        this.fallbackPassword = fallbackPassword;
        this.gatherFallbackUrl = gatherFallbackUrl;
        this.gatherFallbackMethod = gatherFallbackMethod;
    }

    public static GatherBuilder builder() {
        return new GatherBuilder();
    }

    public static class GatherBuilder {
        private List<AudioProducer> audioProducer;
        private URI gatherUrl;
        private Method gatherMethod;
        private String username;
        private String password;
        private String tag;
        private String terminatingDigits;
        private Integer maxDigits;
        private Double interDigitTimeout;
        private Double firstDigitTimeout;
        private Integer repeatCount;
        private String fallbackUsername;
        private String fallbackPassword;
        private URI gatherFallbackUrl;
        private Method gatherFallbackMethod;

        public GatherBuilder gatherUrl(String url) {
            return this.gatherUrl(URI.create(url));
        }

        public GatherBuilder gatherUrl(URI url) {
            this.gatherUrl = url;
            return this;
        }

        public GatherBuilder gatherFallbackUrl(String url) {
            return this.gatherFallbackUrl(URI.create(url));
        }

        public GatherBuilder gatherFallbackUrl(URI url) {
            this.gatherFallbackUrl = url;
            return this;
        }

        public GatherBuilder gatherFallbackMethod(String method) {
            return this.gatherFallbackMethod(Method.fromValue(method));
        }

        public GatherBuilder gatherFallbackMethod(Method method) {
            this.gatherFallbackMethod = method;
            return this;
        }

        public GatherBuilder audioProducer(List<AudioProducer> audioProducers) {
            this.audioProducer = audioProducers;
            return this;
        }

        public GatherBuilder audioProducer(AudioProducer audioProducer) {
            ArrayList<AudioProducer> list = new ArrayList<AudioProducer>();
            list.add(audioProducer);
            return this.audioProducer(list);
        }

        public GatherBuilder gatherMethod(String method) {
            return this.gatherMethod(Method.fromValue(method));
        }

        public GatherBuilder gatherMethod(Method method) {
            this.gatherMethod = method;
            return this;
        }

        GatherBuilder() {
        }

        public GatherBuilder username(String username) {
            this.username = username;
            return this;
        }

        public GatherBuilder password(String password) {
            this.password = password;
            return this;
        }

        public GatherBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public GatherBuilder terminatingDigits(String terminatingDigits) {
            this.terminatingDigits = terminatingDigits;
            return this;
        }

        public GatherBuilder maxDigits(Integer maxDigits) {
            this.maxDigits = maxDigits;
            return this;
        }

        public GatherBuilder interDigitTimeout(Double interDigitTimeout) {
            this.interDigitTimeout = interDigitTimeout;
            return this;
        }

        public GatherBuilder firstDigitTimeout(Double firstDigitTimeout) {
            this.firstDigitTimeout = firstDigitTimeout;
            return this;
        }

        public GatherBuilder repeatCount(Integer repeatCount) {
            this.repeatCount = repeatCount;
            return this;
        }

        public GatherBuilder fallbackUsername(String fallbackUsername) {
            this.fallbackUsername = fallbackUsername;
            return this;
        }

        public GatherBuilder fallbackPassword(String fallbackPassword) {
            this.fallbackPassword = fallbackPassword;
            return this;
        }

        public Gather build() {
            return new Gather(this.audioProducer, this.gatherUrl, this.gatherMethod, this.username, this.password, this.tag, this.terminatingDigits, this.maxDigits, this.interDigitTimeout, this.firstDigitTimeout, this.repeatCount, this.fallbackUsername, this.fallbackPassword, this.gatherFallbackUrl, this.gatherFallbackMethod);
        }

        public String toString() {
            return "Gather.GatherBuilder(audioProducer=" + this.audioProducer + ", gatherUrl=" + this.gatherUrl + ", gatherMethod=" + (Object)((Object)this.gatherMethod) + ", username=" + this.username + ", password=" + this.password + ", tag=" + this.tag + ", terminatingDigits=" + this.terminatingDigits + ", maxDigits=" + this.maxDigits + ", interDigitTimeout=" + this.interDigitTimeout + ", firstDigitTimeout=" + this.firstDigitTimeout + ", repeatCount=" + this.repeatCount + ", fallbackUsername=" + this.fallbackUsername + ", fallbackPassword=" + this.fallbackPassword + ", gatherFallbackUrl=" + this.gatherFallbackUrl + ", gatherFallbackMethod=" + (Object)((Object)this.gatherFallbackMethod) + ")";
        }
    }
}

