/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.bxml.verbs;

import com.bandwidth.voice.bxml.verbs.Method;
import com.bandwidth.voice.bxml.verbs.Verb;
import java.net.URI;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Redirect")
public class Redirect
implements Verb {
    public static final String TYPE_NAME = "Redirect";
    @XmlAttribute
    private URI redirectUrl;
    @XmlAttribute
    private Method redirectMethod;
    @XmlAttribute
    private String tag;
    @XmlAttribute
    protected String username;
    @XmlAttribute
    protected String password;
    @XmlAttribute
    protected String fallbackUsername;
    @XmlAttribute
    protected String fallbackPassword;
    @XmlAttribute
    protected URI redirectFallbackUrl;
    @XmlAttribute
    protected Method redirectFallbackMethod;

    Redirect(URI redirectUrl, Method redirectMethod, String tag, String username, String password, String fallbackUsername, String fallbackPassword, URI redirectFallbackUrl, Method redirectFallbackMethod) {
        this.redirectUrl = redirectUrl;
        this.redirectMethod = redirectMethod;
        this.tag = tag;
        this.username = username;
        this.password = password;
        this.fallbackUsername = fallbackUsername;
        this.fallbackPassword = fallbackPassword;
        this.redirectFallbackUrl = redirectFallbackUrl;
        this.redirectFallbackMethod = redirectFallbackMethod;
    }

    public static RedirectBuilder builder() {
        return new RedirectBuilder();
    }

    public static class RedirectBuilder {
        private URI redirectUrl;
        private Method redirectMethod;
        private String tag;
        private String username;
        private String password;
        private String fallbackUsername;
        private String fallbackPassword;
        private URI redirectFallbackUrl;
        private Method redirectFallbackMethod;

        public RedirectBuilder redirectUrl(URI uri) {
            this.redirectUrl = uri;
            return this;
        }

        public RedirectBuilder redirectUrl(String uri) {
            return this.redirectUrl(URI.create(uri));
        }

        public RedirectBuilder redirectFallbackUrl(URI uri) {
            this.redirectUrl = uri;
            return this;
        }

        public RedirectBuilder redirectFallbackUrl(String uri) {
            return this.redirectUrl(URI.create(uri));
        }

        public RedirectBuilder redirectMethod(Method method) {
            this.redirectMethod = method;
            return this;
        }

        public RedirectBuilder redirectMethod(String method) {
            return this.redirectMethod(Method.fromValue(method));
        }

        public RedirectBuilder redirectFallbackMethod(Method method) {
            this.redirectFallbackMethod = method;
            return this;
        }

        public RedirectBuilder redirectFallbackMethod(String method) {
            return this.redirectFallbackMethod(Method.fromValue(method));
        }

        RedirectBuilder() {
        }

        public RedirectBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public RedirectBuilder username(String username) {
            this.username = username;
            return this;
        }

        public RedirectBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RedirectBuilder fallbackUsername(String fallbackUsername) {
            this.fallbackUsername = fallbackUsername;
            return this;
        }

        public RedirectBuilder fallbackPassword(String fallbackPassword) {
            this.fallbackPassword = fallbackPassword;
            return this;
        }

        public Redirect build() {
            return new Redirect(this.redirectUrl, this.redirectMethod, this.tag, this.username, this.password, this.fallbackUsername, this.fallbackPassword, this.redirectFallbackUrl, this.redirectFallbackMethod);
        }

        public String toString() {
            return "Redirect.RedirectBuilder(redirectUrl=" + this.redirectUrl + ", redirectMethod=" + (Object)((Object)this.redirectMethod) + ", tag=" + this.tag + ", username=" + this.username + ", password=" + this.password + ", fallbackUsername=" + this.fallbackUsername + ", fallbackPassword=" + this.fallbackPassword + ", redirectFallbackUrl=" + this.redirectFallbackUrl + ", redirectFallbackMethod=" + (Object)((Object)this.redirectFallbackMethod) + ")";
        }
    }
}

