/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.bxml.verbs;

import com.bandwidth.voice.bxml.verbs.Method;
import com.bandwidth.voice.bxml.verbs.Verb;
import java.net.URI;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(name="SipUri")
public class SipUri
implements Verb {
    public static final String TYPE_NAME = "SipUri";
    @XmlValue
    private String sipUri;
    @XmlAttribute
    private String uui;
    @XmlAttribute
    private URI transferAnswerUrl;
    @XmlAttribute
    private Method transferAnswerMethod;
    @XmlAttribute
    private URI transferAnswerFallbackUrl;
    @XmlAttribute
    private Method transferAnswerFallbackMethod;
    @XmlAttribute
    private URI transferDisconnectUrl;
    @XmlAttribute
    private Method transferDisconnectMethod;
    @XmlAttribute
    private String username;
    @XmlAttribute
    private String password;
    @XmlAttribute
    private String fallbackUsername;
    @XmlAttribute
    private String fallbackPassword;
    @XmlAttribute
    private String tag;

    SipUri(String sipUri, String uui, URI transferAnswerUrl, Method transferAnswerMethod, URI transferAnswerFallbackUrl, Method transferAnswerFallbackMethod, URI transferDisconnectUrl, Method transferDisconnectMethod, String username, String password, String fallbackUsername, String fallbackPassword, String tag) {
        this.sipUri = sipUri;
        this.uui = uui;
        this.transferAnswerUrl = transferAnswerUrl;
        this.transferAnswerMethod = transferAnswerMethod;
        this.transferAnswerFallbackUrl = transferAnswerFallbackUrl;
        this.transferAnswerFallbackMethod = transferAnswerFallbackMethod;
        this.transferDisconnectUrl = transferDisconnectUrl;
        this.transferDisconnectMethod = transferDisconnectMethod;
        this.username = username;
        this.password = password;
        this.fallbackUsername = fallbackUsername;
        this.fallbackPassword = fallbackPassword;
        this.tag = tag;
    }

    public static SipUriBuilder builder() {
        return new SipUriBuilder();
    }

    public static class SipUriBuilder {
        private String sipUri;
        private String uui;
        private URI transferAnswerUrl;
        private Method transferAnswerMethod;
        private URI transferAnswerFallbackUrl;
        private Method transferAnswerFallbackMethod;
        private URI transferDisconnectUrl;
        private Method transferDisconnectMethod;
        private String username;
        private String password;
        private String fallbackUsername;
        private String fallbackPassword;
        private String tag;

        public SipUriBuilder transferAnswerUrl(URI uri) {
            this.transferAnswerUrl = uri;
            return this;
        }

        public SipUriBuilder transferAnswerUrl(String uri) {
            return this.transferAnswerUrl(URI.create(uri));
        }

        public SipUriBuilder transferAnswerMethod(Method method) {
            this.transferAnswerMethod = method;
            return this;
        }

        public SipUriBuilder transferAnswerMethod(String method) {
            return this.transferAnswerMethod(Method.fromValue(method));
        }

        public SipUriBuilder transferAnswerFallbackUrl(URI uri) {
            this.transferAnswerFallbackUrl = uri;
            return this;
        }

        public SipUriBuilder transferAnswerFallbackUrl(String uri) {
            return this.transferAnswerFallbackUrl(URI.create(uri));
        }

        public SipUriBuilder transferAnswerFallbackMethod(Method method) {
            this.transferAnswerFallbackMethod = method;
            return this;
        }

        public SipUriBuilder transferAnswerFallbackMethod(String method) {
            return this.transferAnswerFallbackMethod(Method.fromValue(method));
        }

        public SipUriBuilder transferDisconnectUrl(URI uri) {
            this.transferDisconnectUrl = uri;
            return this;
        }

        public SipUriBuilder transferDisconnectUrl(String uri) {
            return this.transferDisconnectUrl(URI.create(uri));
        }

        public SipUriBuilder transferDisconnectMethod(Method method) {
            this.transferDisconnectMethod = method;
            return this;
        }

        public SipUriBuilder transferDisconnectMethod(String method) {
            return this.transferDisconnectMethod(Method.fromValue(method));
        }

        SipUriBuilder() {
        }

        public SipUriBuilder sipUri(String sipUri) {
            this.sipUri = sipUri;
            return this;
        }

        public SipUriBuilder uui(String uui) {
            this.uui = uui;
            return this;
        }

        public SipUriBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SipUriBuilder password(String password) {
            this.password = password;
            return this;
        }

        public SipUriBuilder fallbackUsername(String fallbackUsername) {
            this.fallbackUsername = fallbackUsername;
            return this;
        }

        public SipUriBuilder fallbackPassword(String fallbackPassword) {
            this.fallbackPassword = fallbackPassword;
            return this;
        }

        public SipUriBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public SipUri build() {
            return new SipUri(this.sipUri, this.uui, this.transferAnswerUrl, this.transferAnswerMethod, this.transferAnswerFallbackUrl, this.transferAnswerFallbackMethod, this.transferDisconnectUrl, this.transferDisconnectMethod, this.username, this.password, this.fallbackUsername, this.fallbackPassword, this.tag);
        }

        public String toString() {
            return "SipUri.SipUriBuilder(sipUri=" + this.sipUri + ", uui=" + this.uui + ", transferAnswerUrl=" + this.transferAnswerUrl + ", transferAnswerMethod=" + (Object)((Object)this.transferAnswerMethod) + ", transferAnswerFallbackUrl=" + this.transferAnswerFallbackUrl + ", transferAnswerFallbackMethod=" + (Object)((Object)this.transferAnswerFallbackMethod) + ", transferDisconnectUrl=" + this.transferDisconnectUrl + ", transferDisconnectMethod=" + (Object)((Object)this.transferDisconnectMethod) + ", username=" + this.username + ", password=" + this.password + ", fallbackUsername=" + this.fallbackUsername + ", fallbackPassword=" + this.fallbackPassword + ", tag=" + this.tag + ")";
        }
    }
}

