/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.controllers;

import com.bandwidth.ApiHelper;
import com.bandwidth.AuthManager;
import com.bandwidth.Configuration;
import com.bandwidth.Server;
import com.bandwidth.controllers.BaseController;
import com.bandwidth.exceptions.ApiException;
import com.bandwidth.http.Headers;
import com.bandwidth.http.client.HttpCallback;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpContext;
import com.bandwidth.http.request.HttpBodyRequest;
import com.bandwidth.http.request.HttpRequest;
import com.bandwidth.http.response.ApiResponse;
import com.bandwidth.http.response.HttpResponse;
import com.bandwidth.http.response.HttpStringResponse;
import com.bandwidth.voice.exceptions.ApiErrorException;
import com.bandwidth.voice.models.CallRecordingMetadata;
import com.bandwidth.voice.models.CallState;
import com.bandwidth.voice.models.ConferenceMemberState;
import com.bandwidth.voice.models.ConferenceRecordingMetadata;
import com.bandwidth.voice.models.ConferenceState;
import com.bandwidth.voice.models.CreateCallRequest;
import com.bandwidth.voice.models.CreateCallResponse;
import com.bandwidth.voice.models.DynamicResponse;
import com.bandwidth.voice.models.ModifyCallRecordingRequest;
import com.bandwidth.voice.models.ModifyCallRequest;
import com.bandwidth.voice.models.ModifyConferenceRequest;
import com.bandwidth.voice.models.TranscribeRecordingRequest;
import com.bandwidth.voice.models.TranscriptionResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class APIController
extends BaseController {
    public APIController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public APIController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    public ApiResponse<CreateCallResponse> createCall(String accountId, CreateCallRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateCallRequest(accountId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateCallResponse(context);
    }

    public CompletableFuture<ApiResponse<CreateCallResponse>> createCallAsync(String accountId, CreateCallRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateCallRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateCallResponse(context));
    }

    private HttpRequest buildCreateCallRequest(String accountId, CreateCallRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<CreateCallResponse> handleCreateCallResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CreateCallResponse result = ApiHelper.deserialize(responseBody, CreateCallResponse.class);
        return new ApiResponse<CreateCallResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<CallState> getCall(String accountId, String callId) throws ApiException, IOException {
        HttpRequest request = this.buildGetCallRequest(accountId, callId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetCallResponse(context);
    }

    public CompletableFuture<ApiResponse<CallState>> getCallAsync(String accountId, String callId) {
        return this.makeHttpCallAsync(() -> this.buildGetCallRequest(accountId, callId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetCallResponse(context));
    }

    private HttpRequest buildGetCallRequest(String accountId, String callId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<CallState> handleGetCallResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CallState result = ApiHelper.deserialize(responseBody, CallState.class);
        return new ApiResponse<CallState>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> modifyCall(String accountId, String callId, ModifyCallRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildModifyCallRequest(accountId, callId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleModifyCallResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> modifyCallAsync(String accountId, String callId, ModifyCallRequest body) {
        return this.makeHttpCallAsync(() -> this.buildModifyCallRequest(accountId, callId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleModifyCallResponse(context));
    }

    private HttpRequest buildModifyCallRequest(String accountId, String callId, ModifyCallRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleModifyCallResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Void> modifyCallRecordingState(String accountId, String callId, ModifyCallRecordingRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildModifyCallRecordingStateRequest(accountId, callId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleModifyCallRecordingStateResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> modifyCallRecordingStateAsync(String accountId, String callId, ModifyCallRecordingRequest body) {
        return this.makeHttpCallAsync(() -> this.buildModifyCallRecordingStateRequest(accountId, callId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleModifyCallRecordingStateResponse(context));
    }

    private HttpRequest buildModifyCallRecordingStateRequest(String accountId, String callId, ModifyCallRecordingRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recording");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleModifyCallRecordingStateResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<List<CallRecordingMetadata>> getCallRecordings(String accountId, String callId) throws ApiException, IOException {
        HttpRequest request = this.buildGetCallRecordingsRequest(accountId, callId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetCallRecordingsResponse(context);
    }

    public CompletableFuture<ApiResponse<List<CallRecordingMetadata>>> getCallRecordingsAsync(String accountId, String callId) {
        return this.makeHttpCallAsync(() -> this.buildGetCallRecordingsRequest(accountId, callId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetCallRecordingsResponse(context));
    }

    private HttpRequest buildGetCallRecordingsRequest(String accountId, String callId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<List<CallRecordingMetadata>> handleGetCallRecordingsResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, CallRecordingMetadata[].class);
        return new ApiResponse<List<CallRecordingMetadata>>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<CallRecordingMetadata> getCallRecording(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildGetCallRecordingRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetCallRecordingResponse(context);
    }

    public CompletableFuture<ApiResponse<CallRecordingMetadata>> getCallRecordingAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildGetCallRecordingRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetCallRecordingResponse(context));
    }

    private HttpRequest buildGetCallRecordingRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<CallRecordingMetadata> handleGetCallRecordingResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CallRecordingMetadata result = ApiHelper.deserialize(responseBody, CallRecordingMetadata.class);
        return new ApiResponse<CallRecordingMetadata>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> deleteRecording(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteRecordingRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteRecordingResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRecordingAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteRecordingRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteRecordingResponse(context));
    }

    private HttpRequest buildDeleteRecordingRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleDeleteRecordingResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<DynamicResponse> getDownloadCallRecording(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildGetDownloadCallRecordingRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetDownloadCallRecordingResponse(context);
    }

    public CompletableFuture<ApiResponse<DynamicResponse>> getDownloadCallRecordingAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildGetDownloadCallRecordingRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetDownloadCallRecordingResponse(context));
    }

    private HttpRequest buildGetDownloadCallRecordingRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}/media");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<DynamicResponse> handleGetDownloadCallRecordingResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        DynamicResponse result = new DynamicResponse(response);
        return new ApiResponse<DynamicResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> deleteRecordingMedia(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteRecordingMediaRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteRecordingMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRecordingMediaAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteRecordingMediaRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteRecordingMediaResponse(context));
    }

    private HttpRequest buildDeleteRecordingMediaRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}/media");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleDeleteRecordingMediaResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<TranscriptionResponse> getCallTranscription(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildGetCallTranscriptionRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetCallTranscriptionResponse(context);
    }

    public CompletableFuture<ApiResponse<TranscriptionResponse>> getCallTranscriptionAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildGetCallTranscriptionRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetCallTranscriptionResponse(context));
    }

    private HttpRequest buildGetCallTranscriptionRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}/transcription");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<TranscriptionResponse> handleGetCallTranscriptionResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        TranscriptionResponse result = ApiHelper.deserialize(responseBody, TranscriptionResponse.class);
        return new ApiResponse<TranscriptionResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> createTranscribeCallRecording(String accountId, String callId, String recordingId, TranscribeRecordingRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateTranscribeCallRecordingRequest(accountId, callId, recordingId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateTranscribeCallRecordingResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> createTranscribeCallRecordingAsync(String accountId, String callId, String recordingId, TranscribeRecordingRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateTranscribeCallRecordingRequest(accountId, callId, recordingId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateTranscribeCallRecordingResponse(context));
    }

    private HttpRequest buildCreateTranscribeCallRecordingRequest(String accountId, String callId, String recordingId, TranscribeRecordingRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}/transcription");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleCreateTranscribeCallRecordingResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 410) {
            throw new ApiErrorException("The media for this recording has been deleted, so we can't transcribe it", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Void> deleteCallTranscription(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteCallTranscriptionRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteCallTranscriptionResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCallTranscriptionAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteCallTranscriptionRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteCallTranscriptionResponse(context));
    }

    private HttpRequest buildDeleteCallTranscriptionRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}/transcription");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleDeleteCallTranscriptionResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<List<ConferenceState>> getConferences(String accountId, String name, String minCreatedTime, String maxCreatedTime, Integer pageSize, String pageToken) throws ApiException, IOException {
        HttpRequest request = this.buildGetConferencesRequest(accountId, name, minCreatedTime, maxCreatedTime, pageSize, pageToken);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetConferencesResponse(context);
    }

    public CompletableFuture<ApiResponse<List<ConferenceState>>> getConferencesAsync(String accountId, String name, String minCreatedTime, String maxCreatedTime, Integer pageSize, String pageToken) {
        return this.makeHttpCallAsync(() -> this.buildGetConferencesRequest(accountId, name, minCreatedTime, maxCreatedTime, pageSize, pageToken), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetConferencesResponse(context));
    }

    private HttpRequest buildGetConferencesRequest(String accountId, String name, String minCreatedTime, String maxCreatedTime, Integer pageSize, String pageToken) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("name", name);
        queryParameters.put("minCreatedTime", minCreatedTime);
        queryParameters.put("maxCreatedTime", maxCreatedTime);
        queryParameters.put("pageSize", pageSize != null ? pageSize : 1000);
        queryParameters.put("pageToken", pageToken);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<List<ConferenceState>> handleGetConferencesResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, ConferenceState[].class);
        return new ApiResponse<List<ConferenceState>>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<ConferenceState> getConference(String accountId, String conferenceId) throws ApiException, IOException {
        HttpRequest request = this.buildGetConferenceRequest(accountId, conferenceId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetConferenceResponse(context);
    }

    public CompletableFuture<ApiResponse<ConferenceState>> getConferenceAsync(String accountId, String conferenceId) {
        return this.makeHttpCallAsync(() -> this.buildGetConferenceRequest(accountId, conferenceId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetConferenceResponse(context));
    }

    private HttpRequest buildGetConferenceRequest(String accountId, String conferenceId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<ConferenceState> handleGetConferenceResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ConferenceState result = ApiHelper.deserialize(responseBody, ConferenceState.class);
        return new ApiResponse<ConferenceState>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> modifyConference(String accountId, String conferenceId, ModifyConferenceRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildModifyConferenceRequest(accountId, conferenceId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleModifyConferenceResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> modifyConferenceAsync(String accountId, String conferenceId, ModifyConferenceRequest body) {
        return this.makeHttpCallAsync(() -> this.buildModifyConferenceRequest(accountId, conferenceId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleModifyConferenceResponse(context));
    }

    private HttpRequest buildModifyConferenceRequest(String accountId, String conferenceId, ModifyConferenceRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleModifyConferenceResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Void> modifyConferenceMember(String accountId, String conferenceId, String callId, ConferenceMemberState body) throws ApiException, IOException {
        HttpRequest request = this.buildModifyConferenceMemberRequest(accountId, conferenceId, callId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleModifyConferenceMemberResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> modifyConferenceMemberAsync(String accountId, String conferenceId, String callId, ConferenceMemberState body) {
        return this.makeHttpCallAsync(() -> this.buildModifyConferenceMemberRequest(accountId, conferenceId, callId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleModifyConferenceMemberResponse(context));
    }

    private HttpRequest buildModifyConferenceMemberRequest(String accountId, String conferenceId, String callId, ConferenceMemberState body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}/members/{callId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, false));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleModifyConferenceMemberResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<ConferenceMemberState> getConferenceMember(String accountId, String conferenceId, String memberId) throws ApiException, IOException {
        HttpRequest request = this.buildGetConferenceMemberRequest(accountId, conferenceId, memberId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetConferenceMemberResponse(context);
    }

    public CompletableFuture<ApiResponse<ConferenceMemberState>> getConferenceMemberAsync(String accountId, String conferenceId, String memberId) {
        return this.makeHttpCallAsync(() -> this.buildGetConferenceMemberRequest(accountId, conferenceId, memberId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetConferenceMemberResponse(context));
    }

    private HttpRequest buildGetConferenceMemberRequest(String accountId, String conferenceId, String memberId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}/members/{memberId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, false));
        templateParameters.put("memberId", new AbstractMap.SimpleEntry<String, Boolean>(memberId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<ConferenceMemberState> handleGetConferenceMemberResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ConferenceMemberState result = ApiHelper.deserialize(responseBody, ConferenceMemberState.class);
        return new ApiResponse<ConferenceMemberState>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<List<ConferenceRecordingMetadata>> getConferenceRecordings(String accountId, String conferenceId) throws ApiException, IOException {
        HttpRequest request = this.buildGetConferenceRecordingsRequest(accountId, conferenceId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetConferenceRecordingsResponse(context);
    }

    public CompletableFuture<ApiResponse<List<ConferenceRecordingMetadata>>> getConferenceRecordingsAsync(String accountId, String conferenceId) {
        return this.makeHttpCallAsync(() -> this.buildGetConferenceRecordingsRequest(accountId, conferenceId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetConferenceRecordingsResponse(context));
    }

    private HttpRequest buildGetConferenceRecordingsRequest(String accountId, String conferenceId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}/recordings");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<List<ConferenceRecordingMetadata>> handleGetConferenceRecordingsResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, ConferenceRecordingMetadata[].class);
        return new ApiResponse<List<ConferenceRecordingMetadata>>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<CallRecordingMetadata> getConferenceRecording(String accountId, String conferenceId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildGetConferenceRecordingRequest(accountId, conferenceId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetConferenceRecordingResponse(context);
    }

    public CompletableFuture<ApiResponse<CallRecordingMetadata>> getConferenceRecordingAsync(String accountId, String conferenceId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildGetConferenceRecordingRequest(accountId, conferenceId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetConferenceRecordingResponse(context));
    }

    private HttpRequest buildGetConferenceRecordingRequest(String accountId, String conferenceId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}/recordings/{recordingId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, false));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<CallRecordingMetadata> handleGetConferenceRecordingResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        CallRecordingMetadata result = ApiHelper.deserialize(responseBody, CallRecordingMetadata.class);
        return new ApiResponse<CallRecordingMetadata>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<DynamicResponse> getDownloadConferenceRecording(String accountId, String conferenceId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildGetDownloadConferenceRecordingRequest(accountId, conferenceId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetDownloadConferenceRecordingResponse(context);
    }

    public CompletableFuture<ApiResponse<DynamicResponse>> getDownloadConferenceRecordingAsync(String accountId, String conferenceId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildGetDownloadConferenceRecordingRequest(accountId, conferenceId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetDownloadConferenceRecordingResponse(context));
    }

    private HttpRequest buildGetDownloadConferenceRecordingRequest(String accountId, String conferenceId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}/recordings/{recordingId}/media");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, false));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<DynamicResponse> handleGetDownloadConferenceRecordingResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        DynamicResponse result = new DynamicResponse(response);
        return new ApiResponse<DynamicResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<List<CallRecordingMetadata>> getQueryCallRecordings(String accountId, String from, String to, String minStartTime, String maxStartTime) throws ApiException, IOException {
        HttpRequest request = this.buildGetQueryCallRecordingsRequest(accountId, from, to, minStartTime, maxStartTime);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetQueryCallRecordingsResponse(context);
    }

    public CompletableFuture<ApiResponse<List<CallRecordingMetadata>>> getQueryCallRecordingsAsync(String accountId, String from, String to, String minStartTime, String maxStartTime) {
        return this.makeHttpCallAsync(() -> this.buildGetQueryCallRecordingsRequest(accountId, from, to, minStartTime, maxStartTime), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetQueryCallRecordingsResponse(context));
    }

    private HttpRequest buildGetQueryCallRecordingsRequest(String accountId, String from, String to, String minStartTime, String maxStartTime) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/recordings");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("from", from);
        queryParameters.put("to", to);
        queryParameters.put("minStartTime", minStartTime);
        queryParameters.put("maxStartTime", maxStartTime);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<List<CallRecordingMetadata>> handleGetQueryCallRecordingsResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiErrorException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, CallRecordingMetadata[].class);
        return new ApiResponse<List<CallRecordingMetadata>>(response.getStatusCode(), response.getHeaders(), result);
    }
}

