/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.models;

import com.bandwidth.DateTimeHelper;
import com.bandwidth.internal.OptionalNullable;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalDateTime;
import java.util.Map;

public class CallState {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String callId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> parentCallId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String applicationId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String accountId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String to;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String from;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String direction;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String state;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> identity;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, String> pai;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private LocalDateTime startTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<LocalDateTime> answerTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<LocalDateTime> endTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> disconnectCause;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> errorMessage;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> errorId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private LocalDateTime lastUpdate;

    public CallState() {
    }

    public CallState(String callId, String parentCallId, String applicationId, String accountId, String to, String from, String direction, String state, String identity, Map<String, String> pai, LocalDateTime startTime, LocalDateTime answerTime, LocalDateTime endTime, String disconnectCause, String errorMessage, String errorId, LocalDateTime lastUpdate) {
        this.callId = callId;
        this.parentCallId = OptionalNullable.of(parentCallId);
        this.applicationId = applicationId;
        this.accountId = accountId;
        this.to = to;
        this.from = from;
        this.direction = direction;
        this.state = state;
        this.identity = OptionalNullable.of(identity);
        this.pai = pai;
        this.startTime = startTime;
        this.answerTime = OptionalNullable.of(answerTime);
        this.endTime = OptionalNullable.of(endTime);
        this.disconnectCause = OptionalNullable.of(disconnectCause);
        this.errorMessage = OptionalNullable.of(errorMessage);
        this.errorId = OptionalNullable.of(errorId);
        this.lastUpdate = lastUpdate;
    }

    protected CallState(String callId, OptionalNullable<String> parentCallId, String applicationId, String accountId, String to, String from, String direction, String state, OptionalNullable<String> identity, Map<String, String> pai, LocalDateTime startTime, OptionalNullable<LocalDateTime> answerTime, OptionalNullable<LocalDateTime> endTime, OptionalNullable<String> disconnectCause, OptionalNullable<String> errorMessage, OptionalNullable<String> errorId, LocalDateTime lastUpdate) {
        this.callId = callId;
        this.parentCallId = parentCallId;
        this.applicationId = applicationId;
        this.accountId = accountId;
        this.to = to;
        this.from = from;
        this.direction = direction;
        this.state = state;
        this.identity = identity;
        this.pai = pai;
        this.startTime = startTime;
        this.answerTime = answerTime;
        this.endTime = endTime;
        this.disconnectCause = disconnectCause;
        this.errorMessage = errorMessage;
        this.errorId = errorId;
        this.lastUpdate = lastUpdate;
    }

    @JsonGetter(value="callId")
    public String getCallId() {
        return this.callId;
    }

    @JsonSetter(value="callId")
    public void setCallId(String callId) {
        this.callId = callId;
    }

    @JsonGetter(value="parentCallId")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetParentCallId() {
        return this.parentCallId;
    }

    public String getParentCallId() {
        return OptionalNullable.getFrom(this.parentCallId);
    }

    @JsonSetter(value="parentCallId")
    public void setParentCallId(String parentCallId) {
        this.parentCallId = OptionalNullable.of(parentCallId);
    }

    public void unsetParentCallId() {
        this.parentCallId = null;
    }

    @JsonGetter(value="applicationId")
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonSetter(value="applicationId")
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @JsonGetter(value="accountId")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonSetter(value="accountId")
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @JsonGetter(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonSetter(value="to")
    public void setTo(String to) {
        this.to = to;
    }

    @JsonGetter(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonSetter(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    @JsonGetter(value="direction")
    public String getDirection() {
        return this.direction;
    }

    @JsonSetter(value="direction")
    public void setDirection(String direction) {
        this.direction = direction;
    }

    @JsonGetter(value="state")
    public String getState() {
        return this.state;
    }

    @JsonSetter(value="state")
    public void setState(String state) {
        this.state = state;
    }

    @JsonGetter(value="identity")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdentity() {
        return this.identity;
    }

    public String getIdentity() {
        return OptionalNullable.getFrom(this.identity);
    }

    @JsonSetter(value="identity")
    public void setIdentity(String identity) {
        this.identity = OptionalNullable.of(identity);
    }

    public void unsetIdentity() {
        this.identity = null;
    }

    @JsonGetter(value="pai")
    public Map<String, String> getPai() {
        return this.pai;
    }

    @JsonSetter(value="pai")
    public void setPai(Map<String, String> pai) {
        this.pai = pai;
    }

    @JsonGetter(value="startTime")
    @JsonSerialize(using=DateTimeHelper.Rfc8601DateTimeSerializer.class)
    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    @JsonSetter(value="startTime")
    @JsonDeserialize(using=DateTimeHelper.Rfc8601DateTimeDeserializer.class)
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    @JsonGetter(value="answerTime")
    @JsonSerialize(using=OptionalNullable.Rfc8601DateTimeSerializer.class)
    protected OptionalNullable<LocalDateTime> internalGetAnswerTime() {
        return this.answerTime;
    }

    public LocalDateTime getAnswerTime() {
        return OptionalNullable.getFrom(this.answerTime);
    }

    @JsonSetter(value="answerTime")
    @JsonDeserialize(using=DateTimeHelper.Rfc8601DateTimeDeserializer.class)
    public void setAnswerTime(LocalDateTime answerTime) {
        this.answerTime = OptionalNullable.of(answerTime);
    }

    public void unsetAnswerTime() {
        this.answerTime = null;
    }

    @JsonGetter(value="endTime")
    @JsonSerialize(using=OptionalNullable.Rfc8601DateTimeSerializer.class)
    protected OptionalNullable<LocalDateTime> internalGetEndTime() {
        return this.endTime;
    }

    public LocalDateTime getEndTime() {
        return OptionalNullable.getFrom(this.endTime);
    }

    @JsonSetter(value="endTime")
    @JsonDeserialize(using=DateTimeHelper.Rfc8601DateTimeDeserializer.class)
    public void setEndTime(LocalDateTime endTime) {
        this.endTime = OptionalNullable.of(endTime);
    }

    public void unsetEndTime() {
        this.endTime = null;
    }

    @JsonGetter(value="disconnectCause")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDisconnectCause() {
        return this.disconnectCause;
    }

    public String getDisconnectCause() {
        return OptionalNullable.getFrom(this.disconnectCause);
    }

    @JsonSetter(value="disconnectCause")
    public void setDisconnectCause(String disconnectCause) {
        this.disconnectCause = OptionalNullable.of(disconnectCause);
    }

    public void unsetDisconnectCause() {
        this.disconnectCause = null;
    }

    @JsonGetter(value="errorMessage")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorMessage() {
        return OptionalNullable.getFrom(this.errorMessage);
    }

    @JsonSetter(value="errorMessage")
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = OptionalNullable.of(errorMessage);
    }

    public void unsetErrorMessage() {
        this.errorMessage = null;
    }

    @JsonGetter(value="errorId")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetErrorId() {
        return this.errorId;
    }

    public String getErrorId() {
        return OptionalNullable.getFrom(this.errorId);
    }

    @JsonSetter(value="errorId")
    public void setErrorId(String errorId) {
        this.errorId = OptionalNullable.of(errorId);
    }

    public void unsetErrorId() {
        this.errorId = null;
    }

    @JsonGetter(value="lastUpdate")
    @JsonSerialize(using=DateTimeHelper.Rfc8601DateTimeSerializer.class)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonSetter(value="lastUpdate")
    @JsonDeserialize(using=DateTimeHelper.Rfc8601DateTimeDeserializer.class)
    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String toString() {
        return "CallState [callId=" + this.callId + ", parentCallId=" + this.parentCallId + ", applicationId=" + this.applicationId + ", accountId=" + this.accountId + ", to=" + this.to + ", from=" + this.from + ", direction=" + this.direction + ", state=" + this.state + ", identity=" + this.identity + ", pai=" + this.pai + ", startTime=" + this.startTime + ", answerTime=" + this.answerTime + ", endTime=" + this.endTime + ", disconnectCause=" + this.disconnectCause + ", errorMessage=" + this.errorMessage + ", errorId=" + this.errorId + ", lastUpdate=" + this.lastUpdate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().callId(this.getCallId()).applicationId(this.getApplicationId()).accountId(this.getAccountId()).to(this.getTo()).from(this.getFrom()).direction(this.getDirection()).state(this.getState()).pai(this.getPai()).startTime(this.getStartTime()).lastUpdate(this.getLastUpdate());
        builder.parentCallId = this.internalGetParentCallId();
        builder.identity = this.internalGetIdentity();
        builder.answerTime = this.internalGetAnswerTime();
        builder.endTime = this.internalGetEndTime();
        builder.disconnectCause = this.internalGetDisconnectCause();
        builder.errorMessage = this.internalGetErrorMessage();
        builder.errorId = this.internalGetErrorId();
        return builder;
    }

    public static class Builder {
        private String callId;
        private OptionalNullable<String> parentCallId;
        private String applicationId;
        private String accountId;
        private String to;
        private String from;
        private String direction;
        private String state;
        private OptionalNullable<String> identity;
        private Map<String, String> pai;
        private LocalDateTime startTime;
        private OptionalNullable<LocalDateTime> answerTime;
        private OptionalNullable<LocalDateTime> endTime;
        private OptionalNullable<String> disconnectCause;
        private OptionalNullable<String> errorMessage;
        private OptionalNullable<String> errorId;
        private LocalDateTime lastUpdate;

        public Builder callId(String callId) {
            this.callId = callId;
            return this;
        }

        public Builder parentCallId(String parentCallId) {
            this.parentCallId = OptionalNullable.of(parentCallId);
            return this;
        }

        public Builder unsetParentCallId() {
            this.parentCallId = null;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder identity(String identity) {
            this.identity = OptionalNullable.of(identity);
            return this;
        }

        public Builder unsetIdentity() {
            this.identity = null;
            return this;
        }

        public Builder pai(Map<String, String> pai) {
            this.pai = pai;
            return this;
        }

        public Builder startTime(LocalDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder answerTime(LocalDateTime answerTime) {
            this.answerTime = OptionalNullable.of(answerTime);
            return this;
        }

        public Builder unsetAnswerTime() {
            this.answerTime = null;
            return this;
        }

        public Builder endTime(LocalDateTime endTime) {
            this.endTime = OptionalNullable.of(endTime);
            return this;
        }

        public Builder unsetEndTime() {
            this.endTime = null;
            return this;
        }

        public Builder disconnectCause(String disconnectCause) {
            this.disconnectCause = OptionalNullable.of(disconnectCause);
            return this;
        }

        public Builder unsetDisconnectCause() {
            this.disconnectCause = null;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = OptionalNullable.of(errorMessage);
            return this;
        }

        public Builder unsetErrorMessage() {
            this.errorMessage = null;
            return this;
        }

        public Builder errorId(String errorId) {
            this.errorId = OptionalNullable.of(errorId);
            return this;
        }

        public Builder unsetErrorId() {
            this.errorId = null;
            return this;
        }

        public Builder lastUpdate(LocalDateTime lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        public CallState build() {
            return new CallState(this.callId, this.parentCallId, this.applicationId, this.accountId, this.to, this.from, this.direction, this.state, this.identity, this.pai, this.startTime, this.answerTime, this.endTime, this.disconnectCause, this.errorMessage, this.errorId, this.lastUpdate);
        }
    }
}

