/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.models;

import com.bandwidth.internal.OptionalNullable;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;

public class ConferenceMemberState {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String callId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String conferenceId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String memberUrl;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean mute;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean hold;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<List<String>> callIdsToCoach;

    public ConferenceMemberState() {
    }

    public ConferenceMemberState(String callId, String conferenceId, String memberUrl, Boolean mute, Boolean hold, List<String> callIdsToCoach) {
        this.callId = callId;
        this.conferenceId = conferenceId;
        this.memberUrl = memberUrl;
        this.mute = mute;
        this.hold = hold;
        this.callIdsToCoach = OptionalNullable.of(callIdsToCoach);
    }

    protected ConferenceMemberState(String callId, String conferenceId, String memberUrl, Boolean mute, Boolean hold, OptionalNullable<List<String>> callIdsToCoach) {
        this.callId = callId;
        this.conferenceId = conferenceId;
        this.memberUrl = memberUrl;
        this.mute = mute;
        this.hold = hold;
        this.callIdsToCoach = callIdsToCoach;
    }

    @JsonGetter(value="callId")
    public String getCallId() {
        return this.callId;
    }

    @JsonSetter(value="callId")
    public void setCallId(String callId) {
        this.callId = callId;
    }

    @JsonGetter(value="conferenceId")
    public String getConferenceId() {
        return this.conferenceId;
    }

    @JsonSetter(value="conferenceId")
    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    @JsonGetter(value="memberUrl")
    public String getMemberUrl() {
        return this.memberUrl;
    }

    @JsonSetter(value="memberUrl")
    public void setMemberUrl(String memberUrl) {
        this.memberUrl = memberUrl;
    }

    @JsonGetter(value="mute")
    public Boolean getMute() {
        return this.mute;
    }

    @JsonSetter(value="mute")
    public void setMute(Boolean mute) {
        this.mute = mute;
    }

    @JsonGetter(value="hold")
    public Boolean getHold() {
        return this.hold;
    }

    @JsonSetter(value="hold")
    public void setHold(Boolean hold) {
        this.hold = hold;
    }

    @JsonGetter(value="callIdsToCoach")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetCallIdsToCoach() {
        return this.callIdsToCoach;
    }

    public List<String> getCallIdsToCoach() {
        return OptionalNullable.getFrom(this.callIdsToCoach);
    }

    @JsonSetter(value="callIdsToCoach")
    public void setCallIdsToCoach(List<String> callIdsToCoach) {
        this.callIdsToCoach = OptionalNullable.of(callIdsToCoach);
    }

    public void unsetCallIdsToCoach() {
        this.callIdsToCoach = null;
    }

    public String toString() {
        return "ConferenceMemberState [callId=" + this.callId + ", conferenceId=" + this.conferenceId + ", memberUrl=" + this.memberUrl + ", mute=" + this.mute + ", hold=" + this.hold + ", callIdsToCoach=" + this.callIdsToCoach + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().callId(this.getCallId()).conferenceId(this.getConferenceId()).memberUrl(this.getMemberUrl()).mute(this.getMute()).hold(this.getHold());
        builder.callIdsToCoach = this.internalGetCallIdsToCoach();
        return builder;
    }

    public static class Builder {
        private String callId;
        private String conferenceId;
        private String memberUrl;
        private Boolean mute;
        private Boolean hold;
        private OptionalNullable<List<String>> callIdsToCoach;

        public Builder callId(String callId) {
            this.callId = callId;
            return this;
        }

        public Builder conferenceId(String conferenceId) {
            this.conferenceId = conferenceId;
            return this;
        }

        public Builder memberUrl(String memberUrl) {
            this.memberUrl = memberUrl;
            return this;
        }

        public Builder mute(Boolean mute) {
            this.mute = mute;
            return this;
        }

        public Builder hold(Boolean hold) {
            this.hold = hold;
            return this;
        }

        public Builder callIdsToCoach(List<String> callIdsToCoach) {
            this.callIdsToCoach = OptionalNullable.of(callIdsToCoach);
            return this;
        }

        public Builder unsetCallIdsToCoach() {
            this.callIdsToCoach = null;
            return this;
        }

        public ConferenceMemberState build() {
            return new ConferenceMemberState(this.callId, this.conferenceId, this.memberUrl, this.mute, this.hold, this.callIdsToCoach);
        }
    }
}

