/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.models;

import com.bandwidth.DateTimeHelper;
import com.bandwidth.internal.OptionalNullable;
import com.bandwidth.voice.models.ConferenceEventMethodEnum;
import com.bandwidth.voice.models.ConferenceMemberState;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalDateTime;
import java.util.List;

public class ConferenceState {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private LocalDateTime createdTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<LocalDateTime> completedTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> conferenceEventUrl;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<ConferenceEventMethodEnum> conferenceEventMethod;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> tag;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ConferenceMemberState> activeMembers;

    public ConferenceState() {
    }

    public ConferenceState(String id, String name, LocalDateTime createdTime, LocalDateTime completedTime, String conferenceEventUrl, ConferenceEventMethodEnum conferenceEventMethod, String tag, List<ConferenceMemberState> activeMembers) {
        this.id = id;
        this.name = name;
        this.createdTime = createdTime;
        this.completedTime = OptionalNullable.of(completedTime);
        this.conferenceEventUrl = OptionalNullable.of(conferenceEventUrl);
        this.conferenceEventMethod = OptionalNullable.of(conferenceEventMethod);
        this.tag = OptionalNullable.of(tag);
        this.activeMembers = activeMembers;
    }

    protected ConferenceState(String id, String name, LocalDateTime createdTime, OptionalNullable<LocalDateTime> completedTime, OptionalNullable<String> conferenceEventUrl, OptionalNullable<ConferenceEventMethodEnum> conferenceEventMethod, OptionalNullable<String> tag, List<ConferenceMemberState> activeMembers) {
        this.id = id;
        this.name = name;
        this.createdTime = createdTime;
        this.completedTime = completedTime;
        this.conferenceEventUrl = conferenceEventUrl;
        this.conferenceEventMethod = conferenceEventMethod;
        this.tag = tag;
        this.activeMembers = activeMembers;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonGetter(value="createdTime")
    @JsonSerialize(using=DateTimeHelper.Rfc8601DateTimeSerializer.class)
    public LocalDateTime getCreatedTime() {
        return this.createdTime;
    }

    @JsonSetter(value="createdTime")
    @JsonDeserialize(using=DateTimeHelper.Rfc8601DateTimeDeserializer.class)
    public void setCreatedTime(LocalDateTime createdTime) {
        this.createdTime = createdTime;
    }

    @JsonGetter(value="completedTime")
    @JsonSerialize(using=OptionalNullable.Rfc8601DateTimeSerializer.class)
    protected OptionalNullable<LocalDateTime> internalGetCompletedTime() {
        return this.completedTime;
    }

    public LocalDateTime getCompletedTime() {
        return OptionalNullable.getFrom(this.completedTime);
    }

    @JsonSetter(value="completedTime")
    @JsonDeserialize(using=DateTimeHelper.Rfc8601DateTimeDeserializer.class)
    public void setCompletedTime(LocalDateTime completedTime) {
        this.completedTime = OptionalNullable.of(completedTime);
    }

    public void unsetCompletedTime() {
        this.completedTime = null;
    }

    @JsonGetter(value="conferenceEventUrl")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetConferenceEventUrl() {
        return this.conferenceEventUrl;
    }

    public String getConferenceEventUrl() {
        return OptionalNullable.getFrom(this.conferenceEventUrl);
    }

    @JsonSetter(value="conferenceEventUrl")
    public void setConferenceEventUrl(String conferenceEventUrl) {
        this.conferenceEventUrl = OptionalNullable.of(conferenceEventUrl);
    }

    public void unsetConferenceEventUrl() {
        this.conferenceEventUrl = null;
    }

    @JsonGetter(value="conferenceEventMethod")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<ConferenceEventMethodEnum> internalGetConferenceEventMethod() {
        return this.conferenceEventMethod;
    }

    public ConferenceEventMethodEnum getConferenceEventMethod() {
        return OptionalNullable.getFrom(this.conferenceEventMethod);
    }

    @JsonSetter(value="conferenceEventMethod")
    public void setConferenceEventMethod(ConferenceEventMethodEnum conferenceEventMethod) {
        this.conferenceEventMethod = OptionalNullable.of(conferenceEventMethod);
    }

    public void unsetConferenceEventMethod() {
        this.conferenceEventMethod = null;
    }

    @JsonGetter(value="tag")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTag() {
        return this.tag;
    }

    public String getTag() {
        return OptionalNullable.getFrom(this.tag);
    }

    @JsonSetter(value="tag")
    public void setTag(String tag) {
        this.tag = OptionalNullable.of(tag);
    }

    public void unsetTag() {
        this.tag = null;
    }

    @JsonGetter(value="activeMembers")
    public List<ConferenceMemberState> getActiveMembers() {
        return this.activeMembers;
    }

    @JsonSetter(value="activeMembers")
    public void setActiveMembers(List<ConferenceMemberState> activeMembers) {
        this.activeMembers = activeMembers;
    }

    public String toString() {
        return "ConferenceState [id=" + this.id + ", name=" + this.name + ", createdTime=" + this.createdTime + ", completedTime=" + this.completedTime + ", conferenceEventUrl=" + this.conferenceEventUrl + ", conferenceEventMethod=" + this.conferenceEventMethod + ", tag=" + this.tag + ", activeMembers=" + this.activeMembers + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).name(this.getName()).createdTime(this.getCreatedTime()).activeMembers(this.getActiveMembers());
        builder.completedTime = this.internalGetCompletedTime();
        builder.conferenceEventUrl = this.internalGetConferenceEventUrl();
        builder.conferenceEventMethod = this.internalGetConferenceEventMethod();
        builder.tag = this.internalGetTag();
        return builder;
    }

    public static class Builder {
        private String id;
        private String name;
        private LocalDateTime createdTime;
        private OptionalNullable<LocalDateTime> completedTime;
        private OptionalNullable<String> conferenceEventUrl;
        private OptionalNullable<ConferenceEventMethodEnum> conferenceEventMethod;
        private OptionalNullable<String> tag;
        private List<ConferenceMemberState> activeMembers;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder createdTime(LocalDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder completedTime(LocalDateTime completedTime) {
            this.completedTime = OptionalNullable.of(completedTime);
            return this;
        }

        public Builder unsetCompletedTime() {
            this.completedTime = null;
            return this;
        }

        public Builder conferenceEventUrl(String conferenceEventUrl) {
            this.conferenceEventUrl = OptionalNullable.of(conferenceEventUrl);
            return this;
        }

        public Builder unsetConferenceEventUrl() {
            this.conferenceEventUrl = null;
            return this;
        }

        public Builder conferenceEventMethod(ConferenceEventMethodEnum conferenceEventMethod) {
            this.conferenceEventMethod = OptionalNullable.of(conferenceEventMethod);
            return this;
        }

        public Builder unsetConferenceEventMethod() {
            this.conferenceEventMethod = null;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = OptionalNullable.of(tag);
            return this;
        }

        public Builder unsetTag() {
            this.tag = null;
            return this;
        }

        public Builder activeMembers(List<ConferenceMemberState> activeMembers) {
            this.activeMembers = activeMembers;
            return this;
        }

        public ConferenceState build() {
            return new ConferenceState(this.id, this.name, this.createdTime, this.completedTime, this.conferenceEventUrl, this.conferenceEventMethod, this.tag, this.activeMembers);
        }
    }
}

