/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum DirectionEnum {
    INBOUND,
    OUTBOUND;

    private static TreeMap<String, DirectionEnum> valueMap;
    private String value;

    @JsonCreator
    public static DirectionEnum fromString(String toConvert) {
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public static List<String> toValue(List<DirectionEnum> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (DirectionEnum enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        DirectionEnum.INBOUND.value = "inbound";
        DirectionEnum.OUTBOUND.value = "outbound";
        valueMap.put("inbound", INBOUND);
        valueMap.put("outbound", OUTBOUND);
    }
}

