/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.models;

import com.bandwidth.ApiHelper;
import com.bandwidth.http.Headers;
import com.bandwidth.http.response.HttpResponse;
import com.bandwidth.http.response.HttpStringResponse;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Map;

public class DynamicResponse {
    private HttpResponse response;
    private String responseString;

    public DynamicResponse(HttpResponse responseBody) {
        this.response = responseBody;
    }

    public <T> T parse(Class<T> cls) throws ParseException {
        try {
            return ApiHelper.deserialize(this.getResponseString(), cls);
        }
        catch (Exception e) {
            throw new ParseException("Could not deserialize dynamic content as given type", 0);
        }
    }

    public boolean parseAsBoolean() throws ParseException {
        return this.parse(Boolean.class);
    }

    public byte parseAsByte() throws ParseException {
        return this.parse(Byte.class);
    }

    public char parseAsCharacter() throws ParseException {
        return this.parse(Character.class).charValue();
    }

    public float parseAsFloat() throws ParseException {
        return this.parse(Float.class).floatValue();
    }

    public int parseAsInteger() throws ParseException {
        return this.parse(Integer.class);
    }

    public long parseAsLong() throws ParseException {
        return this.parse(Long.class);
    }

    public short parseAsShort() throws ParseException {
        return this.parse(Short.class);
    }

    public double parseAsDouble() throws ParseException {
        return this.parse(Double.class);
    }

    public String parseAsString() throws ParseException {
        try {
            return this.getResponseString();
        }
        catch (Throwable e) {
            throw new ParseException("Could not deserialize dynamic content as given type", 0);
        }
    }

    public Map<String, Object> parseAsDictionary() throws ParseException {
        try {
            return ApiHelper.deserialize(this.getResponseString());
        }
        catch (IOException e) {
            throw new ParseException("Could not deserialize dynamic content as given type", 0);
        }
    }

    public InputStream getRawBody() {
        return this.response.getRawBody();
    }

    public Headers getHeaders() {
        return this.response.getHeaders();
    }

    private String getResponseString() {
        if (this.responseString == null) {
            this.responseString = ((HttpStringResponse)this.response).getBody();
        }
        return this.responseString;
    }
}

