/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.models;

import com.bandwidth.internal.OptionalNullable;
import com.bandwidth.voice.models.CallbackMethodEnum;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class TranscribeRecordingRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String callbackUrl;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<CallbackMethodEnum> callbackMethod;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> username;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> password;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> tag;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<Double> callbackTimeout;

    public TranscribeRecordingRequest() {
    }

    public TranscribeRecordingRequest(String callbackUrl, CallbackMethodEnum callbackMethod, String username, String password, String tag, Double callbackTimeout) {
        this.callbackUrl = callbackUrl;
        this.callbackMethod = OptionalNullable.of(callbackMethod);
        this.username = OptionalNullable.of(username);
        this.password = OptionalNullable.of(password);
        this.tag = OptionalNullable.of(tag);
        this.callbackTimeout = OptionalNullable.of(callbackTimeout);
    }

    protected TranscribeRecordingRequest(String callbackUrl, OptionalNullable<CallbackMethodEnum> callbackMethod, OptionalNullable<String> username, OptionalNullable<String> password, OptionalNullable<String> tag, OptionalNullable<Double> callbackTimeout) {
        this.callbackUrl = callbackUrl;
        this.callbackMethod = callbackMethod;
        this.username = username;
        this.password = password;
        this.tag = tag;
        this.callbackTimeout = callbackTimeout;
    }

    @JsonGetter(value="callbackUrl")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonSetter(value="callbackUrl")
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @JsonGetter(value="callbackMethod")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<CallbackMethodEnum> internalGetCallbackMethod() {
        return this.callbackMethod;
    }

    public CallbackMethodEnum getCallbackMethod() {
        return OptionalNullable.getFrom(this.callbackMethod);
    }

    @JsonSetter(value="callbackMethod")
    public void setCallbackMethod(CallbackMethodEnum callbackMethod) {
        this.callbackMethod = OptionalNullable.of(callbackMethod);
    }

    public void unsetCallbackMethod() {
        this.callbackMethod = null;
    }

    @JsonGetter(value="username")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUsername() {
        return this.username;
    }

    public String getUsername() {
        return OptionalNullable.getFrom(this.username);
    }

    @JsonSetter(value="username")
    public void setUsername(String username) {
        this.username = OptionalNullable.of(username);
    }

    public void unsetUsername() {
        this.username = null;
    }

    @JsonGetter(value="password")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPassword() {
        return this.password;
    }

    public String getPassword() {
        return OptionalNullable.getFrom(this.password);
    }

    @JsonSetter(value="password")
    public void setPassword(String password) {
        this.password = OptionalNullable.of(password);
    }

    public void unsetPassword() {
        this.password = null;
    }

    @JsonGetter(value="tag")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTag() {
        return this.tag;
    }

    public String getTag() {
        return OptionalNullable.getFrom(this.tag);
    }

    @JsonSetter(value="tag")
    public void setTag(String tag) {
        this.tag = OptionalNullable.of(tag);
    }

    public void unsetTag() {
        this.tag = null;
    }

    @JsonGetter(value="callbackTimeout")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Double> internalGetCallbackTimeout() {
        return this.callbackTimeout;
    }

    public Double getCallbackTimeout() {
        return OptionalNullable.getFrom(this.callbackTimeout);
    }

    @JsonSetter(value="callbackTimeout")
    public void setCallbackTimeout(Double callbackTimeout) {
        this.callbackTimeout = OptionalNullable.of(callbackTimeout);
    }

    public void unsetCallbackTimeout() {
        this.callbackTimeout = null;
    }

    public String toString() {
        return "TranscribeRecordingRequest [callbackUrl=" + this.callbackUrl + ", callbackMethod=" + this.callbackMethod + ", username=" + this.username + ", password=" + this.password + ", tag=" + this.tag + ", callbackTimeout=" + this.callbackTimeout + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().callbackUrl(this.getCallbackUrl());
        builder.callbackMethod = this.internalGetCallbackMethod();
        builder.username = this.internalGetUsername();
        builder.password = this.internalGetPassword();
        builder.tag = this.internalGetTag();
        builder.callbackTimeout = this.internalGetCallbackTimeout();
        return builder;
    }

    public static class Builder {
        private String callbackUrl;
        private OptionalNullable<CallbackMethodEnum> callbackMethod;
        private OptionalNullable<String> username;
        private OptionalNullable<String> password;
        private OptionalNullable<String> tag;
        private OptionalNullable<Double> callbackTimeout;

        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder callbackMethod(CallbackMethodEnum callbackMethod) {
            this.callbackMethod = OptionalNullable.of(callbackMethod);
            return this;
        }

        public Builder unsetCallbackMethod() {
            this.callbackMethod = null;
            return this;
        }

        public Builder username(String username) {
            this.username = OptionalNullable.of(username);
            return this;
        }

        public Builder unsetUsername() {
            this.username = null;
            return this;
        }

        public Builder password(String password) {
            this.password = OptionalNullable.of(password);
            return this;
        }

        public Builder unsetPassword() {
            this.password = null;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = OptionalNullable.of(tag);
            return this;
        }

        public Builder unsetTag() {
            this.tag = null;
            return this;
        }

        public Builder callbackTimeout(Double callbackTimeout) {
            this.callbackTimeout = OptionalNullable.of(callbackTimeout);
            return this;
        }

        public Builder unsetCallbackTimeout() {
            this.callbackTimeout = null;
            return this;
        }

        public TranscribeRecordingRequest build() {
            return new TranscribeRecordingRequest(this.callbackUrl, this.callbackMethod, this.username, this.password, this.tag, this.callbackTimeout);
        }
    }
}

