/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.webrtc.controllers;

import com.bandwidth.ApiHelper;
import com.bandwidth.AuthManager;
import com.bandwidth.Configuration;
import com.bandwidth.Server;
import com.bandwidth.controllers.BaseController;
import com.bandwidth.exceptions.ApiException;
import com.bandwidth.http.Headers;
import com.bandwidth.http.client.HttpCallback;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpContext;
import com.bandwidth.http.request.HttpBodyRequest;
import com.bandwidth.http.request.HttpRequest;
import com.bandwidth.http.response.ApiResponse;
import com.bandwidth.http.response.HttpResponse;
import com.bandwidth.http.response.HttpStringResponse;
import com.bandwidth.webrtc.exceptions.ErrorException;
import com.bandwidth.webrtc.models.AccountsParticipantsResponse;
import com.bandwidth.webrtc.models.Participant;
import com.bandwidth.webrtc.models.Session;
import com.bandwidth.webrtc.models.Subscriptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class APIController
extends BaseController {
    public APIController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public APIController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    public ApiResponse<AccountsParticipantsResponse> createParticipant(String accountId, Participant body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateParticipantRequest(accountId, body);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateParticipantResponse(context);
    }

    public CompletableFuture<ApiResponse<AccountsParticipantsResponse>> createParticipantAsync(String accountId, Participant body) {
        return this.makeHttpCallAsync(() -> this.buildCreateParticipantRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateParticipantResponse(context));
    }

    private HttpRequest buildCreateParticipantRequest(String accountId, Participant body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/participants");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<AccountsParticipantsResponse> handleCreateParticipantResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiException("Bad Request", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        AccountsParticipantsResponse result = ApiHelper.deserialize(responseBody, AccountsParticipantsResponse.class);
        return new ApiResponse<AccountsParticipantsResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Participant> getParticipant(String accountId, String participantId) throws ApiException, IOException {
        HttpRequest request = this.buildGetParticipantRequest(accountId, participantId);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetParticipantResponse(context);
    }

    public CompletableFuture<ApiResponse<Participant>> getParticipantAsync(String accountId, String participantId) {
        return this.makeHttpCallAsync(() -> this.buildGetParticipantRequest(accountId, participantId), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetParticipantResponse(context));
    }

    private HttpRequest buildGetParticipantRequest(String accountId, String participantId) {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/participants/{participantId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("participantId", new AbstractMap.SimpleEntry<String, Boolean>(participantId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Participant> handleGetParticipantResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode == 404) {
            throw new ApiException("Not Found", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        Participant result = ApiHelper.deserialize(responseBody, Participant.class);
        return new ApiResponse<Participant>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> deleteParticipant(String accountId, String participantId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteParticipantRequest(accountId, participantId);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteParticipantResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> deleteParticipantAsync(String accountId, String participantId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteParticipantRequest(accountId, participantId), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteParticipantResponse(context));
    }

    private HttpRequest buildDeleteParticipantRequest(String accountId, String participantId) {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/participants/{participantId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("participantId", new AbstractMap.SimpleEntry<String, Boolean>(participantId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleDeleteParticipantResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode == 404) {
            throw new ApiException("Not Found", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Session> createSession(String accountId, Session body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateSessionRequest(accountId, body);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateSessionResponse(context);
    }

    public CompletableFuture<ApiResponse<Session>> createSessionAsync(String accountId, Session body) {
        return this.makeHttpCallAsync(() -> this.buildCreateSessionRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateSessionResponse(context));
    }

    private HttpRequest buildCreateSessionRequest(String accountId, Session body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/sessions");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Session> handleCreateSessionResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiException("Bad Request", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        Session result = ApiHelper.deserialize(responseBody, Session.class);
        return new ApiResponse<Session>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Session> getSession(String accountId, String sessionId) throws ApiException, IOException {
        HttpRequest request = this.buildGetSessionRequest(accountId, sessionId);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetSessionResponse(context);
    }

    public CompletableFuture<ApiResponse<Session>> getSessionAsync(String accountId, String sessionId) {
        return this.makeHttpCallAsync(() -> this.buildGetSessionRequest(accountId, sessionId), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetSessionResponse(context));
    }

    private HttpRequest buildGetSessionRequest(String accountId, String sessionId) {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/sessions/{sessionId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("sessionId", new AbstractMap.SimpleEntry<String, Boolean>(sessionId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Session> handleGetSessionResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode == 404) {
            throw new ApiException("Not Found", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        Session result = ApiHelper.deserialize(responseBody, Session.class);
        return new ApiResponse<Session>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> deleteSession(String accountId, String sessionId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteSessionRequest(accountId, sessionId);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteSessionResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSessionAsync(String accountId, String sessionId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteSessionRequest(accountId, sessionId), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteSessionResponse(context));
    }

    private HttpRequest buildDeleteSessionRequest(String accountId, String sessionId) {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/sessions/{sessionId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("sessionId", new AbstractMap.SimpleEntry<String, Boolean>(sessionId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleDeleteSessionResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode == 404) {
            throw new ApiException("Not Found", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<List<Participant>> listSessionParticipants(String accountId, String sessionId) throws ApiException, IOException {
        HttpRequest request = this.buildListSessionParticipantsRequest(accountId, sessionId);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListSessionParticipantsResponse(context);
    }

    public CompletableFuture<ApiResponse<List<Participant>>> listSessionParticipantsAsync(String accountId, String sessionId) {
        return this.makeHttpCallAsync(() -> this.buildListSessionParticipantsRequest(accountId, sessionId), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListSessionParticipantsResponse(context));
    }

    private HttpRequest buildListSessionParticipantsRequest(String accountId, String sessionId) {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/sessions/{sessionId}/participants");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("sessionId", new AbstractMap.SimpleEntry<String, Boolean>(sessionId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<List<Participant>> handleListSessionParticipantsResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode == 404) {
            throw new ApiException("Not Found", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, Participant[].class);
        return new ApiResponse<List<Participant>>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> addParticipantToSession(String accountId, String sessionId, String participantId, Subscriptions body) throws ApiException, IOException {
        HttpRequest request = this.buildAddParticipantToSessionRequest(accountId, sessionId, participantId, body);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleAddParticipantToSessionResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> addParticipantToSessionAsync(String accountId, String sessionId, String participantId, Subscriptions body) {
        return this.makeHttpCallAsync(() -> this.buildAddParticipantToSessionRequest(accountId, sessionId, participantId, body), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleAddParticipantToSessionResponse(context));
    }

    private HttpRequest buildAddParticipantToSessionRequest(String accountId, String sessionId, String participantId, Subscriptions body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/sessions/{sessionId}/participants/{participantId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("sessionId", new AbstractMap.SimpleEntry<String, Boolean>(sessionId, false));
        templateParameters.put("participantId", new AbstractMap.SimpleEntry<String, Boolean>(participantId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleAddParticipantToSessionResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode == 404) {
            throw new ApiException("Not Found", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Void> removeParticipantFromSession(String accountId, String sessionId, String participantId) throws ApiException, IOException {
        HttpRequest request = this.buildRemoveParticipantFromSessionRequest(accountId, sessionId, participantId);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleRemoveParticipantFromSessionResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> removeParticipantFromSessionAsync(String accountId, String sessionId, String participantId) {
        return this.makeHttpCallAsync(() -> this.buildRemoveParticipantFromSessionRequest(accountId, sessionId, participantId), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleRemoveParticipantFromSessionResponse(context));
    }

    private HttpRequest buildRemoveParticipantFromSessionRequest(String accountId, String sessionId, String participantId) {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/sessions/{sessionId}/participants/{participantId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("sessionId", new AbstractMap.SimpleEntry<String, Boolean>(sessionId, false));
        templateParameters.put("participantId", new AbstractMap.SimpleEntry<String, Boolean>(participantId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleRemoveParticipantFromSessionResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode == 404) {
            throw new ApiException("Not Found", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Subscriptions> getParticipantSubscriptions(String accountId, String sessionId, String participantId) throws ApiException, IOException {
        HttpRequest request = this.buildGetParticipantSubscriptionsRequest(accountId, sessionId, participantId);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetParticipantSubscriptionsResponse(context);
    }

    public CompletableFuture<ApiResponse<Subscriptions>> getParticipantSubscriptionsAsync(String accountId, String sessionId, String participantId) {
        return this.makeHttpCallAsync(() -> this.buildGetParticipantSubscriptionsRequest(accountId, sessionId, participantId), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetParticipantSubscriptionsResponse(context));
    }

    private HttpRequest buildGetParticipantSubscriptionsRequest(String accountId, String sessionId, String participantId) {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/sessions/{sessionId}/participants/{participantId}/subscriptions");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("sessionId", new AbstractMap.SimpleEntry<String, Boolean>(sessionId, false));
        templateParameters.put("participantId", new AbstractMap.SimpleEntry<String, Boolean>(participantId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Subscriptions> handleGetParticipantSubscriptionsResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode == 404) {
            throw new ApiException("Not Found", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        Subscriptions result = ApiHelper.deserialize(responseBody, Subscriptions.class);
        return new ApiResponse<Subscriptions>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> updateParticipantSubscriptions(String accountId, String sessionId, String participantId, Subscriptions body) throws ApiException, IOException {
        HttpRequest request = this.buildUpdateParticipantSubscriptionsRequest(accountId, sessionId, participantId, body);
        ((AuthManager)this.authManagers.get("webRtc")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUpdateParticipantSubscriptionsResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> updateParticipantSubscriptionsAsync(String accountId, String sessionId, String participantId, Subscriptions body) {
        return this.makeHttpCallAsync(() -> this.buildUpdateParticipantSubscriptionsRequest(accountId, sessionId, participantId, body), req -> ((AuthManager)this.authManagers.get("webRtc")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUpdateParticipantSubscriptionsResponse(context));
    }

    private HttpRequest buildUpdateParticipantSubscriptionsRequest(String accountId, String sessionId, String participantId, Subscriptions body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.WEBRTCDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/sessions/{sessionId}/participants/{participantId}/subscriptions");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("sessionId", new AbstractMap.SimpleEntry<String, Boolean>(sessionId, false));
        templateParameters.put("participantId", new AbstractMap.SimpleEntry<String, Boolean>(participantId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleUpdateParticipantSubscriptionsResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ApiException("Bad Request", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Unauthorized", context);
        }
        if (responseCode == 403) {
            throw new ApiException("Access Denied", context);
        }
        if (responseCode == 404) {
            throw new ApiException("Not Found", context);
        }
        if (responseCode < 200 || responseCode > 208) {
            throw new ErrorException("Unexpected Error", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }
}

