/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.webrtc.models;

import com.bandwidth.internal.OptionalNullable;
import com.bandwidth.webrtc.models.DeviceApiVersionEnum;
import com.bandwidth.webrtc.models.PublishPermissionEnum;
import com.bandwidth.webrtc.models.Subscriptions;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;

public class Participant {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OptionalNullable<String> callbackUrl;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<PublishPermissionEnum> publishPermissions;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> sessions;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Subscriptions subscriptions;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String tag;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private DeviceApiVersionEnum deviceApiVersion;

    public Participant() {
        this.deviceApiVersion = DeviceApiVersionEnum.V2;
    }

    public Participant(String id, String callbackUrl, List<PublishPermissionEnum> publishPermissions, List<String> sessions, Subscriptions subscriptions, String tag, DeviceApiVersionEnum deviceApiVersion) {
        this.id = id;
        this.callbackUrl = OptionalNullable.of(callbackUrl);
        this.publishPermissions = publishPermissions;
        this.sessions = sessions;
        this.subscriptions = subscriptions;
        this.tag = tag;
        this.deviceApiVersion = deviceApiVersion;
    }

    protected Participant(String id, OptionalNullable<String> callbackUrl, List<PublishPermissionEnum> publishPermissions, List<String> sessions, Subscriptions subscriptions, String tag, DeviceApiVersionEnum deviceApiVersion) {
        this.id = id;
        this.callbackUrl = callbackUrl;
        this.publishPermissions = publishPermissions;
        this.sessions = sessions;
        this.subscriptions = subscriptions;
        this.tag = tag;
        this.deviceApiVersion = deviceApiVersion;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="callbackUrl")
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCallbackUrl() {
        return this.callbackUrl;
    }

    public String getCallbackUrl() {
        return OptionalNullable.getFrom(this.callbackUrl);
    }

    @JsonSetter(value="callbackUrl")
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = OptionalNullable.of(callbackUrl);
    }

    public void unsetCallbackUrl() {
        this.callbackUrl = null;
    }

    @JsonGetter(value="publishPermissions")
    public List<PublishPermissionEnum> getPublishPermissions() {
        return this.publishPermissions;
    }

    @JsonSetter(value="publishPermissions")
    public void setPublishPermissions(List<PublishPermissionEnum> publishPermissions) {
        this.publishPermissions = publishPermissions;
    }

    @JsonGetter(value="sessions")
    public List<String> getSessions() {
        return this.sessions;
    }

    @JsonSetter(value="sessions")
    public void setSessions(List<String> sessions) {
        this.sessions = sessions;
    }

    @JsonGetter(value="subscriptions")
    public Subscriptions getSubscriptions() {
        return this.subscriptions;
    }

    @JsonSetter(value="subscriptions")
    public void setSubscriptions(Subscriptions subscriptions) {
        this.subscriptions = subscriptions;
    }

    @JsonGetter(value="tag")
    public String getTag() {
        return this.tag;
    }

    @JsonSetter(value="tag")
    public void setTag(String tag) {
        this.tag = tag;
    }

    @JsonGetter(value="deviceApiVersion")
    public DeviceApiVersionEnum getDeviceApiVersion() {
        return this.deviceApiVersion;
    }

    @JsonSetter(value="deviceApiVersion")
    public void setDeviceApiVersion(DeviceApiVersionEnum deviceApiVersion) {
        this.deviceApiVersion = deviceApiVersion;
    }

    public String toString() {
        return "Participant [id=" + this.id + ", callbackUrl=" + this.callbackUrl + ", publishPermissions=" + this.publishPermissions + ", sessions=" + this.sessions + ", subscriptions=" + this.subscriptions + ", tag=" + this.tag + ", deviceApiVersion=" + (Object)((Object)this.deviceApiVersion) + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).publishPermissions(this.getPublishPermissions()).sessions(this.getSessions()).subscriptions(this.getSubscriptions()).tag(this.getTag()).deviceApiVersion(this.getDeviceApiVersion());
        builder.callbackUrl = this.internalGetCallbackUrl();
        return builder;
    }

    public static class Builder {
        private String id;
        private OptionalNullable<String> callbackUrl;
        private List<PublishPermissionEnum> publishPermissions;
        private List<String> sessions;
        private Subscriptions subscriptions;
        private String tag;
        private DeviceApiVersionEnum deviceApiVersion = DeviceApiVersionEnum.V2;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = OptionalNullable.of(callbackUrl);
            return this;
        }

        public Builder unsetCallbackUrl() {
            this.callbackUrl = null;
            return this;
        }

        public Builder publishPermissions(List<PublishPermissionEnum> publishPermissions) {
            this.publishPermissions = publishPermissions;
            return this;
        }

        public Builder sessions(List<String> sessions) {
            this.sessions = sessions;
            return this;
        }

        public Builder subscriptions(Subscriptions subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder deviceApiVersion(DeviceApiVersionEnum deviceApiVersion) {
            this.deviceApiVersion = deviceApiVersion;
            return this;
        }

        public Participant build() {
            return new Participant(this.id, this.callbackUrl, this.publishPermissions, this.sessions, this.subscriptions, this.tag, this.deviceApiVersion);
        }
    }
}

