/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.paris.processor.android_resource_scanner;

import com.airbnb.paris.processor.android_resource_scanner.AndroidResourceId;
import com.squareup.javapoet.ClassName;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class AndroidResourceScanner {
    private Types typeUtils;
    private Elements elementUtils;
    private Trees trees;

    public void init(ProcessingEnvironment processingEnv) {
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        try {
            this.trees = Trees.instance(processingEnv);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public AndroidResourceId getId(Class<? extends Annotation> annotation, Element element, int value) {
        Map<Integer, AndroidResourceId> results = this.getResults(annotation, element);
        if (results.containsKey(value)) {
            return results.get(value);
        }
        return null;
    }

    private static AnnotationMirror getMirror(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotation.getCanonicalName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private Map<Integer, AndroidResourceId> getResults(Class<? extends Annotation> annotation, Element element) {
        AnnotationScanner scanner = new AnnotationScanner();
        JCTree tree = (JCTree)this.trees.getTree(element, AndroidResourceScanner.getMirror(element, annotation));
        if (tree != null) {
            tree.accept(scanner);
        }
        return scanner.results();
    }

    private ClassName getClassName(String rClass, String rTypeClass) {
        Element rClassElement;
        try {
            rClassElement = this.elementUtils.getTypeElement(rClass);
        }
        catch (MirroredTypeException mte) {
            rClassElement = this.typeUtils.asElement(mte.getTypeMirror());
        }
        String rClassPackageName = this.elementUtils.getPackageOf(rClassElement).getQualifiedName().toString();
        return ClassName.get((String)rClassPackageName, (String)"R", (String[])new String[]{rTypeClass});
    }

    private class AnnotationScanner
    extends TreeScanner {
        private final Map<Integer, AndroidResourceId> results = new HashMap<Integer, AndroidResourceId>();

        private AnnotationScanner() {
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jcFieldAccess) {
            Symbol symbol = jcFieldAccess.sym;
            if (symbol instanceof Symbol.VarSymbol && symbol.getEnclosingElement() != null && symbol.getEnclosingElement().getEnclosingElement() != null && symbol.getEnclosingElement().getEnclosingElement().enclClass() != null) {
                this.parseResourceSymbol((Symbol.VarSymbol)symbol);
            }
        }

        private void parseResourceSymbol(Symbol.VarSymbol symbol) {
            String rClass = ((Symbol)symbol.getEnclosingElement()).getEnclosingElement().enclClass().className();
            String rTypeClass = ((Symbol)symbol.getEnclosingElement()).getSimpleName().toString();
            String resourceName = ((Name)symbol.getSimpleName()).toString();
            Object value = symbol.getConstantValue();
            if (!(value instanceof Integer)) {
                return;
            }
            AndroidResourceId androidResourceId = new AndroidResourceId((Integer)value, AndroidResourceScanner.this.getClassName(rClass, rTypeClass), resourceName);
            this.results.put(androidResourceId.getValue(), androidResourceId);
        }

        Map<Integer, AndroidResourceId> results() {
            return this.results;
        }
    }
}

