/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.paris.processor.models;

import com.airbnb.paris.annotations.Styleable;
import com.airbnb.paris.processor.ParisProcessor;
import com.airbnb.paris.processor.WithParisProcessor;
import com.airbnb.paris.processor.android_resource_scanner.AndroidResourceId;
import com.airbnb.paris.processor.framework.Message;
import com.airbnb.paris.processor.models.EmptyStyleInfo;
import com.airbnb.paris.processor.models.StyleCompanionPropertyInfo;
import com.airbnb.paris.processor.models.StyleCompanionPropertyInfoExtractor;
import com.airbnb.paris.processor.models.StyleInfo;
import com.airbnb.paris.processor.models.StyleInfoExtractor;
import com.airbnb.paris.processor.models.StyleResInfo;
import com.airbnb.paris.processor.models.StyleStaticMethodInfo;
import com.airbnb.paris.processor.models.StyleStaticMethodInfoExtractor;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR0\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/airbnb/paris/processor/models/StyleInfoExtractor;", "Lcom/airbnb/paris/processor/WithParisProcessor;", "processor", "Lcom/airbnb/paris/processor/ParisProcessor;", "(Lcom/airbnb/paris/processor/ParisProcessor;)V", "<set-?>", "", "Lcom/airbnb/paris/processor/models/StyleInfo;", "latest", "getLatest", "()Ljava/util/List;", "setLatest", "(Ljava/util/List;)V", "models", "getModels", "setModels", "getProcessor", "()Lcom/airbnb/paris/processor/ParisProcessor;", "styleCompanionPropertyInfoExtractor", "Lcom/airbnb/paris/processor/models/StyleCompanionPropertyInfoExtractor;", "styleStaticMethodInfoExtractor", "Lcom/airbnb/paris/processor/models/StyleStaticMethodInfoExtractor;", "fromDefaultNameFormat", "styleableElement", "Ljavax/lang/model/element/Element;", "process", "", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "paris-processor"})
public final class StyleInfoExtractor
implements WithParisProcessor {
    @NotNull
    private List<? extends StyleInfo> models;
    @NotNull
    private List<? extends StyleInfo> latest;
    private StyleCompanionPropertyInfoExtractor styleCompanionPropertyInfoExtractor;
    private StyleStaticMethodInfoExtractor styleStaticMethodInfoExtractor;
    @NotNull
    private final ParisProcessor processor;

    @NotNull
    public final List<StyleInfo> getModels() {
        return this.models;
    }

    private final void setModels(List<? extends StyleInfo> list) {
        this.models = list;
    }

    @NotNull
    public final List<StyleInfo> getLatest() {
        return this.latest;
    }

    private final void setLatest(List<? extends StyleInfo> list) {
        this.latest = list;
    }

    public final void process(@NotNull RoundEnvironment roundEnv) {
        Object value$iv$iv$iv;
        Object it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)roundEnv, (String)"roundEnv");
        Set<? extends Element> styleableElements = roundEnv.getElementsAnnotatedWith(Styleable.class);
        this.styleCompanionPropertyInfoExtractor.process(roundEnv);
        this.styleStaticMethodInfoExtractor.process(roundEnv);
        List list = this.styleCompanionPropertyInfoExtractor.getLatest();
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<com.airbnb.paris.processor.models.StyleInfo>");
        }
        Iterable iterable = CollectionsKt.plus((Collection)list, (Iterable)this.styleStaticMethodInfoExtractor.getLatest());
        void var5_4 = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator.next();
            it = (StyleInfo)element$iv$iv;
            Element key$iv$iv = it.getEnclosingElement();
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map stylesFromStyleAnnotation = destination$iv$iv;
        Set<? extends Element> set = styleableElements;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"styleableElements");
        $receiver$iv = set;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Element)item$iv$iv;
            Object object = destination$iv$iv;
            List list2 = (List)stylesFromStyleAnnotation.get(it);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Pair pair = TuplesKt.to((Object)it, (Object)list2);
            object.add(pair);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Iterable iterable2;
            Object v5;
            StyleInfo styleWithNameDefault;
            List styles;
            Element styleableElement;
            block19: {
                Object v4;
                Object object2;
                block18: {
                    Pair $styleableElement_styles = (Pair)element$iv$iv;
                    styleableElement = (Element)$styleableElement_styles.component1();
                    styles = (List)$styleableElement_styles.component2();
                    Iterable $i$f$map = styles;
                    value$iv$iv$iv = $i$f$map;
                    for (Object object2 : value$iv$iv$iv) {
                        StyleInfo it2 = (StyleInfo)object2;
                        if (!Intrinsics.areEqual((Object)it2.getFormattedName(), (Object)"Default")) continue;
                        v4 = object2;
                        break block18;
                    }
                    v4 = null;
                }
                styleWithNameDefault = v4;
                Object v = value$iv$iv$iv = (Iterable)styles;
                object2 = v.iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    StyleInfo it3 = (StyleInfo)e;
                    if (!it3.isDefault()) continue;
                    v5 = e;
                    break block19;
                }
                v5 = null;
            }
            StyleInfo styleMarkedAsDefault = v5;
            if (Intrinsics.areEqual((Object)styleWithNameDefault, (Object)styleMarkedAsDefault) ^ true && styleWithNameDefault != null && styleMarkedAsDefault != null) {
                this.logError(styleableElement, (Function0<String>)((Function0)process.2.1.INSTANCE));
            }
            if (styleWithNameDefault != null) {
                iterable2 = styles;
            } else {
                List list3;
                if (styleMarkedAsDefault != null) {
                    StyleInfo styleInfo;
                    Collection collection = styles;
                    value$iv$iv$iv = styleMarkedAsDefault;
                    if (value$iv$iv$iv instanceof StyleCompanionPropertyInfo) {
                        styleInfo = new StyleCompanionPropertyInfo(((StyleCompanionPropertyInfo)styleMarkedAsDefault).getElement(), styleMarkedAsDefault.getElementName(), "Default", styleMarkedAsDefault.getJavadoc(), styleMarkedAsDefault.getKdoc(), true);
                    } else if (value$iv$iv$iv instanceof StyleStaticMethodInfo) {
                        styleInfo = new StyleStaticMethodInfo(((StyleStaticMethodInfo)styleMarkedAsDefault).getElement(), styleMarkedAsDefault.getElementName(), "Default", styleMarkedAsDefault.getJavadoc(), styleMarkedAsDefault.getKdoc(), true);
                    } else {
                        throw (Throwable)new IllegalStateException();
                    }
                    list3 = CollectionsKt.plus((Collection)collection, (Object)styleInfo);
                } else {
                    StyleInfo defaultNameFormatStyle = this.fromDefaultNameFormat(styleableElement);
                    list3 = defaultNameFormatStyle != null ? CollectionsKt.plus((Collection)styles, (Object)defaultNameFormatStyle) : CollectionsKt.plus((Collection)styles, (Object)new EmptyStyleInfo(styleableElement, true));
                }
                iterable2 = list3;
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable it4 = iterable = (List)destination$iv$iv;
        this.models = CollectionsKt.plus((Collection)this.models, (Iterable)it4);
        this.latest = it4;
    }

    private final StyleInfo fromDefaultNameFormat(Element styleableElement) {
        boolean defaultStyleExists;
        TypeElement rStyleTypeElement;
        String defaultStyleName;
        block6: {
            boolean bl;
            if (StringsKt.isBlank((CharSequence)this.getDefaultStyleNameFormat())) {
                return null;
            }
            String elementName = styleableElement.getSimpleName().toString();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string = this.getDefaultStyleNameFormat();
            Object[] objectArray = new Object[]{elementName};
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            defaultStyleName = string2;
            Elements elements2 = this.getElements();
            StringBuilder stringBuilder = new StringBuilder();
            TypeElement typeElement = this.getRElement();
            if (typeElement == null) {
                Intrinsics.throwNpe();
            }
            rStyleTypeElement = elements2.getTypeElement(stringBuilder.append((Object)typeElement.getQualifiedName()).append(".style").toString());
            List<? extends Element> list = this.getElements().getAllMembers(rStyleTypeElement);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"elements.getAllMembers(rStyleTypeElement)");
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Element it;
                    Element element = it = (Element)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                    if (!Intrinsics.areEqual((Object)element.getSimpleName().toString(), (Object)defaultStyleName)) continue;
                    bl = true;
                    break block6;
                }
                bl = defaultStyleExists = false;
            }
        }
        if (defaultStyleExists) {
            CodeBlock styleResourceCode = CodeBlock.of((String)"$T.$L", (Object[])new Object[]{rStyleTypeElement, defaultStyleName});
            CodeBlock javadoc = CodeBlock.of((String)("See " + defaultStyleName + " style (defined as an XML resource)"), (Object[])new Object[0]);
            String string = javadoc.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javadoc.toString()");
            com.squareup.kotlinpoet.CodeBlock kdoc = com.squareup.kotlinpoet.CodeBlock.Companion.of(string, new Object[0]);
            CodeBlock codeBlock = javadoc;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"javadoc");
            CodeBlock codeBlock2 = styleResourceCode;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock2, (String)"styleResourceCode");
            return new StyleResInfo(styleableElement, defaultStyleName, "Default", codeBlock, kdoc, true, codeBlock2);
        }
        return null;
    }

    @Override
    @NotNull
    public ParisProcessor getProcessor() {
        return this.processor;
    }

    public StyleInfoExtractor(@NotNull ParisProcessor processor) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        this.processor = processor;
        this.models = CollectionsKt.emptyList();
        this.latest = CollectionsKt.emptyList();
        this.styleCompanionPropertyInfoExtractor = new StyleCompanionPropertyInfoExtractor(this.getProcessor());
        this.styleStaticMethodInfoExtractor = new StyleStaticMethodInfoExtractor(this.getProcessor());
    }

    @Override
    @Nullable
    public TypeElement getRElement() {
        return WithParisProcessor.DefaultImpls.getRElement(this);
    }

    @Override
    @NotNull
    public String getDefaultStyleNameFormat() {
        return WithParisProcessor.DefaultImpls.getDefaultStyleNameFormat(this);
    }

    @Override
    @Nullable
    public AndroidResourceId getResourceId(@NotNull Class<? extends Annotation> annotation, @NotNull Element element, int value) {
        Intrinsics.checkParameterIsNotNull(annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return WithParisProcessor.DefaultImpls.getResourceId(this, annotation, element, value);
    }

    @Override
    @NotNull
    public Filer getFiler() {
        return WithParisProcessor.DefaultImpls.getFiler(this);
    }

    @Override
    @NotNull
    public Messager getMessager() {
        return WithParisProcessor.DefaultImpls.getMessager(this);
    }

    @Override
    @NotNull
    public Elements getElements() {
        return WithParisProcessor.DefaultImpls.getElements(this);
    }

    @Override
    @NotNull
    public Types getTypes() {
        return WithParisProcessor.DefaultImpls.getTypes(this);
    }

    @Override
    @Nullable
    public String getKaptOutputPath() {
        return WithParisProcessor.DefaultImpls.getKaptOutputPath(this);
    }

    @Override
    @NotNull
    public List<Message> getLoggedMessages() {
        return WithParisProcessor.DefaultImpls.getLoggedMessages(this);
    }

    @Override
    @NotNull
    public TypeMirror erasure(@NotNull TypeMirror type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return WithParisProcessor.DefaultImpls.erasure(this, type);
    }

    @Override
    public boolean isSameType(@NotNull TypeMirror type1, @NotNull TypeMirror type2) {
        Intrinsics.checkParameterIsNotNull((Object)type1, (String)"type1");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type2");
        return WithParisProcessor.DefaultImpls.isSameType(this, type1, type2);
    }

    @Override
    public boolean isSubtype(@NotNull TypeMirror type1, @NotNull TypeMirror type2) {
        Intrinsics.checkParameterIsNotNull((Object)type1, (String)"type1");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type2");
        return WithParisProcessor.DefaultImpls.isSubtype(this, type1, type2);
    }

    @Override
    @NotNull
    public TypeElement toTypeElement(@NotNull ClassName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return WithParisProcessor.DefaultImpls.toTypeElement(this, $receiver);
    }

    @Override
    @NotNull
    public TypeMirror toTypeMirror(@NotNull ClassName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return WithParisProcessor.DefaultImpls.toTypeMirror(this, $receiver);
    }

    @Override
    @NotNull
    public PackageElement getPackageElement(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return WithParisProcessor.DefaultImpls.getPackageElement(this, $receiver);
    }

    @Override
    @NotNull
    public TypeElement asTypeElement(@NotNull TypeMirror $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return WithParisProcessor.DefaultImpls.asTypeElement(this, $receiver);
    }

    @Override
    public boolean isNonExistent(@NotNull TypeMirror $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return WithParisProcessor.DefaultImpls.isNonExistent(this, $receiver);
    }

    @Override
    public boolean isView(@NotNull TypeMirror type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return WithParisProcessor.DefaultImpls.isView(this, type);
    }

    @Override
    public void logError(@NotNull Element element, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(lazyMessage, (String)"lazyMessage");
        WithParisProcessor.DefaultImpls.logError(this, element, lazyMessage);
    }

    @Override
    public void logError(@NotNull Function0<String> lazyMessage) {
        Intrinsics.checkParameterIsNotNull(lazyMessage, (String)"lazyMessage");
        WithParisProcessor.DefaultImpls.logError(this, lazyMessage);
    }

    @Override
    public void logWarning(@NotNull Element element, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(lazyMessage, (String)"lazyMessage");
        WithParisProcessor.DefaultImpls.logWarning(this, element, lazyMessage);
    }

    @Override
    public void logWarning(@NotNull Function0<String> lazyMessage) {
        Intrinsics.checkParameterIsNotNull(lazyMessage, (String)"lazyMessage");
        WithParisProcessor.DefaultImpls.logWarning(this, lazyMessage);
    }

    @Override
    public void printLogsIfAny(@NotNull Messager messager2) {
        Intrinsics.checkParameterIsNotNull((Object)messager2, (String)"messager");
        WithParisProcessor.DefaultImpls.printLogsIfAny(this, messager2);
    }
}

