/*
 * Decompiled with CFR 0.152.
 */
package com.banno.vault;

import cats.Alternative;
import cats.Alternative$;
import cats.ApplicativeError;
import cats.Apply;
import cats.Foldable;
import cats.effect.Concurrent;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.implicits$;
import cats.kernel.Monoid;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.OptionIdOps$;
import com.banno.vault.Vault;
import com.banno.vault.Vault$;
import com.banno.vault.models.CertificateData$;
import com.banno.vault.models.CertificateRequest;
import com.banno.vault.models.CertificateRequest$;
import com.banno.vault.models.VaultRequestError$;
import com.banno.vault.models.VaultSecret;
import com.banno.vault.models.VaultSecret$;
import com.banno.vault.models.VaultSecretRenewal;
import com.banno.vault.models.VaultSecretRenewal$;
import com.banno.vault.models.VaultToken;
import com.banno.vault.models.VaultToken$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import io.chrisdavenport.vault.Vault;
import io.circe.Decoder;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Json;
import io.circe.Json$;
import io.circe.syntax.package;
import org.http4s.DecodeFailure;
import org.http4s.Header;
import org.http4s.Header$;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.InvalidMessageBodyFailure;
import org.http4s.InvalidMessageBodyFailure$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Status;
import org.http4s.Uri;
import org.http4s.circe.package$;
import org.http4s.client.Client;
import org.http4s.client.UnexpectedStatus;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class Vault$ {
    public static final Vault$ MODULE$;
    public final Function1<DecodingFailure, DecodeFailure> com$banno$vault$Vault$$decoderError;

    static {
        new Vault$();
    }

    public <F> F login(Client<F> client, Uri vaultUri, String roleId, Sync<F> F) {
        Request request = (Request)Request$.MODULE$.apply((Method)Method$.MODULE$.POST(), vaultUri.$div("v1").$div("auth").$div("approle").$div("login"), Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()).withEntity((Object)Json$.MODULE$.obj((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"role_id", (Object)Json$.MODULE$.fromString(roleId))})), package$.MODULE$.jsonEncoder(F));
        return (F)implicits$.MODULE$.toFlatMapOps(F.handleErrorWith(client.expect(request, package$.MODULE$.jsonDecoder(F)), (Function1)new Serializable(roleId, F, request){
            public static final long serialVersionUID = 0L;
            private final String roleId$1;
            private final Sync F$1;
            private final Request request$1;

            public final F apply(Throwable e) {
                return (F)this.F$1.raiseError((Object)VaultRequestError$.MODULE$.apply(this.request$1, (Option<Throwable>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)e)), (Option<String>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roleId=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.roleId$1}))))));
            }
            {
                this.roleId$1 = roleId$1;
                this.F$1 = F$1;
                this.request$1 = request$1;
            }
        }), F).flatMap((Function1)new Serializable(F){
            public static final long serialVersionUID = 0L;
            private final Sync F$1;

            public final F apply(Json json) {
                return Vault$.MODULE$.com$banno$vault$Vault$$raiseKnownError(json.hcursor().get("auth", VaultToken$.MODULE$.vaultTokenDecoder()), Vault$.MODULE$.com$banno$vault$Vault$$decoderError, this.F$1);
            }
            {
                this.F$1 = F$1;
            }
        });
    }

    public <F> F kubernetesLogin(Client<F> client, Uri vaultUri, String role, String jwt, Sync<F> F) {
        Request request = (Request)Request$.MODULE$.apply((Method)Method$.MODULE$.POST(), vaultUri.$div("v1").$div("auth").$div("kubernetes").$div("login"), Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()).withEntity((Object)Json$.MODULE$.obj((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"role", (Object)Json$.MODULE$.fromString(role)), new Tuple2((Object)"jwt", (Object)Json$.MODULE$.fromString(jwt))})), package$.MODULE$.jsonEncoder(F));
        return (F)implicits$.MODULE$.toFlatMapOps(F.handleErrorWith(client.expect(request, package$.MODULE$.jsonDecoder(F)), (Function1)new Serializable(role, F, request){
            public static final long serialVersionUID = 0L;
            private final String role$1;
            private final Sync F$2;
            private final Request request$2;

            public final F apply(Throwable e) {
                return (F)this.F$2.raiseError((Object)VaultRequestError$.MODULE$.apply(this.request$2, (Option<Throwable>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)e)), (Option<String>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"role=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.role$1}))))));
            }
            {
                this.role$1 = role$1;
                this.F$2 = F$2;
                this.request$2 = request$2;
            }
        }), F).flatMap((Function1)new Serializable(F){
            public static final long serialVersionUID = 0L;
            private final Sync F$2;

            public final F apply(Json json) {
                return Vault$.MODULE$.com$banno$vault$Vault$$raiseKnownError(json.hcursor().get("auth", VaultToken$.MODULE$.vaultTokenDecoder()), Vault$.MODULE$.com$banno$vault$Vault$$decoderError, this.F$2);
            }
            {
                this.F$2 = F$2;
            }
        });
    }

    public <F, A> F readSecret(Client<F> client, Uri vaultUri, String token, String secretPath, Sync<F> F, Decoder<A> D) {
        String newSecretPath = secretPath.startsWith("/") ? secretPath.substring(1) : secretPath;
        Method.Semantics$.Safe x$12 = Method$.MODULE$.GET();
        Uri x$13 = vaultUri.withPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/v1/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newSecretPath})));
        List x$14 = Headers$.MODULE$.of((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{Header$.MODULE$.apply("X-Vault-Token", token)}));
        HttpVersion x$15 = Request$.MODULE$.apply$default$3();
        FreeC x$16 = Request$.MODULE$.apply$default$5();
        Vault x$17 = Request$.MODULE$.apply$default$6();
        Request request = Request$.MODULE$.apply((Method)x$12, x$13, x$15, x$14, x$16, x$17);
        return (F)F.handleErrorWith(client.expect(request, package$.MODULE$.jsonOf(F, VaultSecret$.MODULE$.VaultSecretDecoder(D))), (Function1)new Serializable(token, F, request){
            public static final long serialVersionUID = 0L;
            private final String token$1;
            private final Sync F$3;
            private final Request request$3;

            public final F apply(Throwable e) {
                return (F)this.F$3.raiseError((Object)VaultRequestError$.MODULE$.apply(this.request$3, (Option<Throwable>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)e)), (Option<String>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tokenLength=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.token$1.length())}))))));
            }
            {
                this.token$1 = token$1;
                this.F$3 = F$3;
                this.request$3 = request$3;
            }
        });
    }

    public <F> F renewLease(Client<F> client, Uri vaultUri, String leaseId, FiniteDuration newLeaseDuration, String token, Sync<F> F) {
        Method.Semantics$.Idempotent x$18 = Method$.MODULE$.PUT();
        Uri x$19 = vaultUri.withPath("/v1/sys/leases/renew");
        List x$20 = Headers$.MODULE$.of((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{Header$.MODULE$.apply("X-Vault-Token", token)}));
        HttpVersion x$21 = Request$.MODULE$.apply$default$3();
        FreeC x$22 = Request$.MODULE$.apply$default$5();
        Vault x$23 = Request$.MODULE$.apply$default$6();
        Request request = (Request)Request$.MODULE$.apply((Method)x$18, x$19, x$21, x$20, x$22, x$23).withEntity((Object)Json$.MODULE$.obj((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"lease_id", (Object)Json$.MODULE$.fromString(leaseId)), new Tuple2((Object)"increment", (Object)Json$.MODULE$.fromLong(newLeaseDuration.toSeconds()))})), package$.MODULE$.jsonEncoder(F));
        return (F)F.handleErrorWith(client.expect(request, package$.MODULE$.jsonOf(F, VaultSecretRenewal$.MODULE$.VaultSecretRenewalDecoder())), (Function1)new Serializable(token, F, request){
            public static final long serialVersionUID = 0L;
            private final String token$2;
            private final Sync F$4;
            private final Request request$4;

            public final F apply(Throwable e) {
                return (F)this.F$4.raiseError((Object)VaultRequestError$.MODULE$.apply(this.request$4, (Option<Throwable>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)e)), (Option<String>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tokenLength=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.token$2.length())}))))));
            }
            {
                this.token$2 = token$2;
                this.F$4 = F$4;
                this.request$4 = request$4;
            }
        });
    }

    public <F> F renewSelfToken(Client<F> client, Uri vaultUri, VaultToken token, FiniteDuration newLeaseDuration, Sync<F> F) {
        Method.Semantics$.Default x$24 = Method$.MODULE$.POST();
        Uri x$25 = vaultUri.$div("v1").$div("auth").$div("token").$div("renew-self");
        List x$26 = Headers$.MODULE$.of((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{Header$.MODULE$.apply("X-Vault-Token", token.clientToken())}));
        HttpVersion x$27 = Request$.MODULE$.apply$default$3();
        FreeC x$28 = Request$.MODULE$.apply$default$5();
        Vault x$29 = Request$.MODULE$.apply$default$6();
        Request request = (Request)Request$.MODULE$.apply((Method)x$24, x$25, x$27, x$26, x$28, x$29).withEntity((Object)Json$.MODULE$.obj((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"increment", (Object)Json$.MODULE$.fromString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLeaseDuration.toSeconds())}))))})), package$.MODULE$.jsonEncoder(F));
        return (F)implicits$.MODULE$.toFlatMapOps(F.handleErrorWith(client.expect(request, package$.MODULE$.jsonDecoder(F)), (Function1)new Serializable(token, F, request){
            public static final long serialVersionUID = 0L;
            private final VaultToken token$3;
            private final Sync F$5;
            private final Request request$5;

            public final F apply(Throwable e) {
                return (F)this.F$5.raiseError((Object)VaultRequestError$.MODULE$.apply(this.request$5, (Option<Throwable>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)e)), (Option<String>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tokenLength=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.token$3.clientToken().length())}))))));
            }
            {
                this.token$3 = token$3;
                this.F$5 = F$5;
                this.request$5 = request$5;
            }
        }), F).flatMap((Function1)new Serializable(F){
            public static final long serialVersionUID = 0L;
            private final Sync F$5;

            public final F apply(Json json) {
                return Vault$.MODULE$.com$banno$vault$Vault$$raiseKnownError(json.hcursor().get("auth", VaultToken$.MODULE$.vaultTokenDecoder()), Vault$.MODULE$.com$banno$vault$Vault$$decoderError, this.F$5);
            }
            {
                this.F$5 = F$5;
            }
        });
    }

    public <F> F revokeSelfToken(Client<F> client, Uri vaultUri, VaultToken token, Sync<F> F) {
        Method.Semantics$.Default x$30 = Method$.MODULE$.POST();
        Uri x$31 = vaultUri.$div("v1").$div("auth").$div("token").$div("revoke-self");
        List x$32 = Headers$.MODULE$.of((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{Header$.MODULE$.apply("X-Vault-Token", token.clientToken())}));
        HttpVersion x$33 = Request$.MODULE$.apply$default$3();
        FreeC x$34 = Request$.MODULE$.apply$default$5();
        Vault x$35 = Request$.MODULE$.apply$default$6();
        Request request = Request$.MODULE$.apply((Method)x$30, x$31, x$33, x$32, x$34, x$35);
        Object resp = implicits$.MODULE$.toFunctorOps(MonadErrorOps$.MODULE$.ensureOr$extension(implicits$.MODULE$.catsSyntaxMonadError(client.status(request), F), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UnexpectedStatus apply(Status x$1) {
                return new UnexpectedStatus(x$1);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Status x$2) {
                return x$2.isSuccess();
            }
        }, F), F).void();
        return (F)F.handleErrorWith(resp, (Function1)new Serializable(token, F, request){
            public static final long serialVersionUID = 0L;
            private final VaultToken token$4;
            private final Sync F$6;
            private final Request request$6;

            public final F apply(Throwable e) {
                return (F)this.F$6.raiseError((Object)VaultRequestError$.MODULE$.apply(this.request$6, (Option<Throwable>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)e)), (Option<String>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tokenLength=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.token$4.clientToken().length())}))))));
            }
            {
                this.token$4 = token$4;
                this.F$6 = F$6;
                this.request$6 = request$6;
            }
        });
    }

    public <F> F revokeLease(Client<F> client, Uri vaultUri, String clientToken, String leaseId, Sync<F> F) {
        Method.Semantics$.Idempotent x$36 = Method$.MODULE$.PUT();
        Uri x$37 = vaultUri.withPath("/v1/sys/leases/revoke");
        List x$38 = Headers$.MODULE$.of((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{Header$.MODULE$.apply("X-Vault-Token", clientToken)}));
        HttpVersion x$39 = Request$.MODULE$.apply$default$3();
        FreeC x$40 = Request$.MODULE$.apply$default$5();
        Vault x$41 = Request$.MODULE$.apply$default$6();
        Request request = (Request)Request$.MODULE$.apply((Method)x$36, x$37, x$39, x$38, x$40, x$41).withEntity((Object)Json$.MODULE$.obj((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lease_id"), (Object)Json$.MODULE$.fromString(leaseId))})), package$.MODULE$.jsonEncoder(F));
        return (F)implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(implicits$.MODULE$.catsSyntaxApplicativeError(MonadErrorOps$.MODULE$.ensureOr$extension(implicits$.MODULE$.catsSyntaxMonadError(client.status(request), F), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UnexpectedStatus apply(Status x$3) {
                return new UnexpectedStatus(x$3);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Status x$4) {
                return x$4.isSuccess();
            }
        }, F), F), (Function1)new Serializable(clientToken, F, request){
            public static final long serialVersionUID = 0L;
            private final String clientToken$1;
            private final Sync F$7;
            private final Request request$7;

            public final F apply(Throwable e) {
                return (F)this.F$7.raiseError((Object)VaultRequestError$.MODULE$.apply(this.request$7, (Option<Throwable>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)e)), (Option<String>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tokenLength=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.clientToken$1.length())}))))));
            }
            {
                this.clientToken$1 = clientToken$1;
                this.F$7 = F$7;
                this.request$7 = request$7;
            }
        }, F), F).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Status _) {
            }
        });
    }

    public <F> F generateCertificate(Client<F> client, Uri vaultUri, String token, String secretPath, CertificateRequest payload, Sync<F> F) {
        return this.generateSecret(client, vaultUri, token, secretPath, payload, CertificateRequest$.MODULE$.certificateRequestEncoder(), CertificateData$.MODULE$.CertificateDataDecoder(), F);
    }

    public <F, A, B> F generateSecret(Client<F> client, Uri vaultUri, String token, String secretPath, A payload, Encoder<A> evidence$1, Decoder<B> evidence$2, Sync<F> F) {
        String newSecretPath = secretPath.startsWith("/") ? secretPath.substring(1) : secretPath;
        Method.Semantics$.Default x$42 = Method$.MODULE$.POST();
        Uri x$43 = vaultUri.withPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/v1/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newSecretPath})));
        List x$44 = Headers$.MODULE$.of((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{Header$.MODULE$.apply("X-Vault-Token", token)}));
        HttpVersion x$45 = Request$.MODULE$.apply$default$3();
        FreeC x$46 = Request$.MODULE$.apply$default$5();
        Vault x$47 = Request$.MODULE$.apply$default$6();
        Request request = Request$.MODULE$.apply((Method)x$42, x$43, x$45, x$44, x$46, x$47);
        Request withBody = (Request)request.withEntity((Object)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(payload), evidence$1), package$.MODULE$.jsonEncoder(F));
        return (F)F.handleErrorWith(client.expect(withBody, package$.MODULE$.jsonOf(F, VaultSecret$.MODULE$.VaultSecretDecoder(evidence$2))), (Function1)new Serializable(token, F, withBody){
            public static final long serialVersionUID = 0L;
            private final String token$5;
            private final Sync F$8;
            private final Request withBody$1;

            public final F apply(Throwable e) {
                return (F)this.F$8.raiseError((Object)VaultRequestError$.MODULE$.apply(this.withBody$1, (Option<Throwable>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)e)), (Option<String>)OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tokenLength=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.token$5.length())}))))));
            }
            {
                this.token$5 = token$5;
                this.F$8 = F$8;
                this.withBody$1 = withBody$1;
            }
        });
    }

    public <F, A> FreeC<?, BoxedUnit> keepLoginAndSecretLeased(Client<F> client, Uri vaultUri, VaultToken token, String secretPath, FiniteDuration duration, FiniteDuration waitInterval, Concurrent<F> evidence$3, Decoder<A> evidence$4, Timer<F> T) {
        return Stream$.MODULE$.$plus$plus$extension(((Stream)((Option)Alternative$.MODULE$.apply((Alternative)implicits$.MODULE$.catsStdInstancesForOption()).guard(duration.$greater((Object)waitInterval))).fold((Function0)new Serializable(evidence$3){
            public static final long serialVersionUID = 0L;
            private final Concurrent evidence$3$1;

            public final FreeC<?, BoxedUnit> apply() {
                return Stream$.MODULE$.raiseError((Throwable)new Vault.InvalidRequirement("waitInterval longer than requested Lease Duration"), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)this.evidence$3$1));
            }
            {
                this.evidence$3$1 = evidence$3$1;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FreeC<?, BoxedUnit> apply(BoxedUnit x$5) {
                return Stream.PureOps$.MODULE$.apply$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.empty()));
            }
        })).fs2$Stream$$free(), (Function0)new Serializable(client, vaultUri, token, secretPath, duration, waitInterval, evidence$3, evidence$4, T){
            public static final long serialVersionUID = 0L;
            public final Client client$1;
            public final Uri vaultUri$1;
            private final VaultToken token$6;
            public final String secretPath$1;
            private final FiniteDuration duration$1;
            public final FiniteDuration waitInterval$1;
            public final Concurrent evidence$3$1;
            public final Decoder evidence$4$1;
            public final Timer T$1;

            public final FreeC<?, BoxedUnit> apply() {
                return Stream$.MODULE$.flatMap$extension(Vault$.MODULE$.keepLoginRenewed(this.client$1, this.vaultUri$1, this.token$6, this.duration$1, this.evidence$3$1, this.T$1), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.keepLoginAndSecretLeased.3 $outer;

                    public final FreeC<?, BoxedUnit> apply(String clientToken) {
                        return Vault$.MODULE$.readSecretAndRetain(this.$outer.client$1, this.$outer.vaultUri$1, clientToken, this.$outer.secretPath$1, this.$outer.waitInterval$1, this.$outer.evidence$3$1, this.$outer.evidence$4$1, this.$outer.T$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.client$1 = client$1;
                this.vaultUri$1 = vaultUri$1;
                this.token$6 = token$6;
                this.secretPath$1 = secretPath$1;
                this.duration$1 = duration$1;
                this.waitInterval$1 = waitInterval$1;
                this.evidence$3$1 = evidence$3$1;
                this.evidence$4$1 = evidence$4$1;
                this.T$1 = T$1;
            }
        });
    }

    public <F, A> FreeC<?, BoxedUnit> loginAndKeepSecretLeased(Client<F> client, Uri vaultUri, String roleId, String secretPath, FiniteDuration duration, FiniteDuration waitInterval, Concurrent<F> evidence$5, Decoder<A> evidence$6, Timer<F> T) {
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(this.login(client, vaultUri, roleId, (Sync<F>)evidence$5)), (Function1)new Serializable(client, vaultUri, secretPath, duration, waitInterval, evidence$5, evidence$6, T){
            public static final long serialVersionUID = 0L;
            private final Client client$4;
            private final Uri vaultUri$4;
            private final String secretPath$2;
            private final FiniteDuration duration$2;
            private final FiniteDuration waitInterval$2;
            private final Concurrent evidence$5$1;
            private final Decoder evidence$6$1;
            private final Timer T$4;

            public final FreeC<?, BoxedUnit> apply(VaultToken token) {
                return Vault$.MODULE$.keepLoginAndSecretLeased(this.client$4, this.vaultUri$4, token, this.secretPath$2, this.duration$2, this.waitInterval$2, this.evidence$5$1, this.evidence$6$1, this.T$4);
            }
            {
                this.client$4 = client$4;
                this.vaultUri$4 = vaultUri$4;
                this.secretPath$2 = secretPath$2;
                this.duration$2 = duration$2;
                this.waitInterval$2 = waitInterval$2;
                this.evidence$5$1 = evidence$5$1;
                this.evidence$6$1 = evidence$6$1;
                this.T$4 = T$4;
            }
        });
    }

    public <F> FreeC<?, BoxedUnit> keepLoginRenewed(Client<F> client, Uri vaultUri, VaultToken token, FiniteDuration tokenLeaseExtension, Concurrent<F> evidence$7, Timer<F> T) {
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.bracket(ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)token), evidence$7), (Function1)new Serializable(client, vaultUri, evidence$7){
            public static final long serialVersionUID = 0L;
            private final Client client$2;
            private final Uri vaultUri$2;
            private final Concurrent evidence$7$1;

            public final F apply(VaultToken token) {
                return (F)Vault$.MODULE$.com$banno$vault$Vault$$cleanup$1(token, this.client$2, this.vaultUri$2, this.evidence$7$1);
            }
            {
                this.client$2 = client$2;
                this.vaultUri$2 = vaultUri$2;
                this.evidence$7$1 = evidence$7$1;
            }
        }), (Function1)new Serializable(client, vaultUri, tokenLeaseExtension, evidence$7, T){
            public static final long serialVersionUID = 0L;
            private final Client client$2;
            private final Uri vaultUri$2;
            private final FiniteDuration tokenLeaseExtension$1;
            private final Concurrent evidence$7$1;
            private final Timer T$2;

            public final FreeC<?, BoxedUnit> apply(VaultToken token) {
                return Stream$.MODULE$.concurrently$extension(Stream$.MODULE$.emit((Object)token.clientToken()), Vault$.MODULE$.com$banno$vault$Vault$$keep$1(token, this.client$2, this.vaultUri$2, this.tokenLeaseExtension$1, this.evidence$7$1, this.T$2), this.evidence$7$1);
            }
            {
                this.client$2 = client$2;
                this.vaultUri$2 = vaultUri$2;
                this.tokenLeaseExtension$1 = tokenLeaseExtension$1;
                this.evidence$7$1 = evidence$7$1;
                this.T$2 = T$2;
            }
        });
    }

    public <F> FreeC<?, BoxedUnit> loginAndKeep(Client<F> client, Uri vaultUri, String roleId, FiniteDuration tokenLeaseExtension, Concurrent<F> evidence$8, Timer<F> T) {
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(this.login(client, vaultUri, roleId, (Sync<F>)evidence$8)), (Function1)new Serializable(client, vaultUri, tokenLeaseExtension, evidence$8, T){
            public static final long serialVersionUID = 0L;
            private final Client client$5;
            private final Uri vaultUri$5;
            private final FiniteDuration tokenLeaseExtension$2;
            private final Concurrent evidence$8$1;
            private final Timer T$5;

            public final FreeC<?, BoxedUnit> apply(VaultToken token) {
                return Vault$.MODULE$.keepLoginRenewed(this.client$5, this.vaultUri$5, token, this.tokenLeaseExtension$2, this.evidence$8$1, this.T$5);
            }
            {
                this.client$5 = client$5;
                this.vaultUri$5 = vaultUri$5;
                this.tokenLeaseExtension$2 = tokenLeaseExtension$2;
                this.evidence$8$1 = evidence$8$1;
                this.T$5 = T$5;
            }
        });
    }

    public <F, A> FreeC<?, BoxedUnit> readSecretAndRetain(Client<F> client, Uri vaultUri, String clientToken, String secretPath, FiniteDuration leaseExtension, Concurrent<F> evidence$9, Decoder<A> evidence$10, Timer<F> T) {
        F read = this.readSecret(client, vaultUri, clientToken, secretPath, (Sync<F>)evidence$9, evidence$10);
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.bracket(read, (Function1)new Serializable(client, vaultUri, clientToken, evidence$9){
            public static final long serialVersionUID = 0L;
            private final Client client$3;
            private final Uri vaultUri$3;
            private final String clientToken$2;
            private final Concurrent evidence$9$1;

            public final F apply(VaultSecret<A> secret) {
                return (F)Vault$.MODULE$.com$banno$vault$Vault$$cleanup$2(secret, this.client$3, this.vaultUri$3, this.clientToken$2, this.evidence$9$1);
            }
            {
                this.client$3 = client$3;
                this.vaultUri$3 = vaultUri$3;
                this.clientToken$2 = clientToken$2;
                this.evidence$9$1 = evidence$9$1;
            }
        }), (Function1)new Serializable(client, vaultUri, clientToken, leaseExtension, evidence$9, T){
            public static final long serialVersionUID = 0L;
            private final Client client$3;
            private final Uri vaultUri$3;
            private final String clientToken$2;
            private final FiniteDuration leaseExtension$1;
            private final Concurrent evidence$9$1;
            private final Timer T$3;

            public final FreeC<?, BoxedUnit> apply(VaultSecret<A> secret) {
                return Stream$.MODULE$.concurrently$extension(Stream$.MODULE$.emit(secret.data()), Vault$.MODULE$.com$banno$vault$Vault$$keep$2(secret, this.client$3, this.vaultUri$3, this.clientToken$2, this.leaseExtension$1, this.evidence$9$1, this.T$3), this.evidence$9$1);
            }
            {
                this.client$3 = client$3;
                this.vaultUri$3 = vaultUri$3;
                this.clientToken$2 = clientToken$2;
                this.leaseExtension$1 = leaseExtension$1;
                this.evidence$9$1 = evidence$9$1;
                this.T$3 = T$3;
            }
        });
    }

    public <F, E1, E2 extends Throwable, A> F com$banno$vault$Vault$$raiseKnownError(Either<E1, A> e, Function1<E1, E2> errorF, Sync<F> F) {
        return (F)F.fromEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(e), errorF));
    }

    public final Object com$banno$vault$Vault$$renewOnDuration$1(VaultToken token, Client client$2, Uri vaultUri$2, FiniteDuration tokenLeaseExtension$1, Concurrent evidence$7$1, Timer T$2) {
        long waitInterval = Math.min(token.leaseDuration(), tokenLeaseExtension$1.toSeconds()) * 9L / 10L;
        return implicits$.MODULE$.catsSyntaxApply(T$2.sleep(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(waitInterval)).seconds()), (Apply)evidence$7$1).$times$greater(this.renewSelfToken((Client)client$2, vaultUri$2, token, tokenLeaseExtension$1, (Sync)evidence$7$1));
    }

    public final FreeC com$banno$vault$Vault$$keep$1(VaultToken token, Client client$2, Uri vaultUri$2, FiniteDuration tokenLeaseExtension$1, Concurrent evidence$7$1, Timer T$2) {
        return Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.last$extension(Stream$.MODULE$.takeThrough$extension(Stream$.MODULE$.iterateEval((Object)token, (Function1)new Serializable(client$2, vaultUri$2, tokenLeaseExtension$1, evidence$7$1, T$2){
            public static final long serialVersionUID = 0L;
            private final Client client$2;
            private final Uri vaultUri$2;
            private final FiniteDuration tokenLeaseExtension$1;
            private final Concurrent evidence$7$1;
            private final Timer T$2;

            public final F apply(VaultToken token) {
                return (F)Vault$.MODULE$.com$banno$vault$Vault$$renewOnDuration$1(token, this.client$2, this.vaultUri$2, this.tokenLeaseExtension$1, this.evidence$7$1, this.T$2);
            }
            {
                this.client$2 = client$2;
                this.vaultUri$2 = vaultUri$2;
                this.tokenLeaseExtension$1 = tokenLeaseExtension$1;
                this.evidence$7$1 = evidence$7$1;
                this.T$2 = T$2;
            }
        }), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(VaultToken x$6) {
                return x$6.renewable();
            }
        })), (Function1)new Serializable(T$2){
            public static final long serialVersionUID = 0L;
            private final Timer T$2;

            public final FreeC<?, BoxedUnit> apply(Option<VaultToken> lastRenewal) {
                return Stream$.MODULE$.sleep(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(BoxesRunTime.unboxToLong((Object)implicits$.MODULE$.toFoldableOps(lastRenewal, (Foldable)implicits$.MODULE$.catsStdInstancesForOption()).foldMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(VaultToken x$7) {
                        return x$7.leaseDuration();
                    }
                }, (Monoid)implicits$.MODULE$.catsKernelStdGroupForLong())))).seconds(), this.T$2);
            }
            {
                this.T$2 = T$2;
            }
        }), (Function0)new Serializable(evidence$7$1, token){
            public static final long serialVersionUID = 0L;
            private final Concurrent evidence$7$1;
            private final VaultToken token$7;

            public final FreeC<?, BoxedUnit> apply() {
                return Stream$.MODULE$.raiseError((Throwable)new Vault.NonRenewableToken(this.token$7.clientToken()), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)this.evidence$7$1));
            }
            {
                this.evidence$7$1 = evidence$7$1;
                this.token$7 = token$7;
            }
        });
    }

    public final Object com$banno$vault$Vault$$cleanup$1(VaultToken token, Client client$2, Uri vaultUri$2, Concurrent evidence$7$1) {
        return ApplicativeErrorOps$.MODULE$.handleError$extension(implicits$.MODULE$.catsSyntaxApplicativeError(this.revokeSelfToken((Client)client$2, vaultUri$2, token, (Sync)evidence$7$1), (ApplicativeError)evidence$7$1), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Throwable x$8) {
            }
        }, (ApplicativeError)evidence$7$1);
    }

    public final Object com$banno$vault$Vault$$renewOnDuration$2(VaultSecretRenewal renewal, Client client$3, Uri vaultUri$3, String clientToken$2, FiniteDuration leaseExtension$1, Concurrent evidence$9$1, Timer T$3) {
        long waitInterval = Math.min(renewal.leaseDuration(), leaseExtension$1.toSeconds()) * 9L / 10L;
        return implicits$.MODULE$.catsSyntaxApply(T$3.sleep(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(waitInterval)).seconds()), (Apply)evidence$9$1).$times$greater(this.renewLease((Client)client$3, vaultUri$3, renewal.leaseId(), leaseExtension$1, clientToken$2, (Sync)evidence$9$1));
    }

    public final FreeC com$banno$vault$Vault$$keep$2(VaultSecret secret, Client client$3, Uri vaultUri$3, String clientToken$2, FiniteDuration leaseExtension$1, Concurrent evidence$9$1, Timer T$3) {
        return Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.last$extension(Stream$.MODULE$.takeThrough$extension(Stream$.MODULE$.iterateEval((Object)secret.renewal(), (Function1)new Serializable(client$3, vaultUri$3, clientToken$2, leaseExtension$1, evidence$9$1, T$3){
            public static final long serialVersionUID = 0L;
            private final Client client$3;
            private final Uri vaultUri$3;
            private final String clientToken$2;
            private final FiniteDuration leaseExtension$1;
            private final Concurrent evidence$9$1;
            private final Timer T$3;

            public final F apply(VaultSecretRenewal renewal) {
                return (F)Vault$.MODULE$.com$banno$vault$Vault$$renewOnDuration$2(renewal, this.client$3, this.vaultUri$3, this.clientToken$2, this.leaseExtension$1, this.evidence$9$1, this.T$3);
            }
            {
                this.client$3 = client$3;
                this.vaultUri$3 = vaultUri$3;
                this.clientToken$2 = clientToken$2;
                this.leaseExtension$1 = leaseExtension$1;
                this.evidence$9$1 = evidence$9$1;
                this.T$3 = T$3;
            }
        }), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(VaultSecretRenewal x$9) {
                return x$9.renewable();
            }
        })), (Function1)new Serializable(T$3){
            public static final long serialVersionUID = 0L;
            private final Timer T$3;

            public final FreeC<?, BoxedUnit> apply(Option<VaultSecretRenewal> lastRenewal) {
                return Stream$.MODULE$.sleep(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(BoxesRunTime.unboxToLong((Object)implicits$.MODULE$.toFoldableOps(lastRenewal, (Foldable)implicits$.MODULE$.catsStdInstancesForOption()).foldMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(VaultSecretRenewal x$10) {
                        return x$10.leaseDuration();
                    }
                }, (Monoid)implicits$.MODULE$.catsKernelStdGroupForLong())))).seconds(), this.T$3);
            }
            {
                this.T$3 = T$3;
            }
        }), (Function0)new Serializable(evidence$9$1, secret){
            public static final long serialVersionUID = 0L;
            private final Concurrent evidence$9$1;
            private final VaultSecret secret$1;

            public final FreeC<?, BoxedUnit> apply() {
                return Stream$.MODULE$.raiseError((Throwable)new Vault.NonRenewableSecret(this.secret$1.renewal().leaseId()), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)this.evidence$9$1));
            }
            {
                this.evidence$9$1 = evidence$9$1;
                this.secret$1 = secret$1;
            }
        });
    }

    public final Object com$banno$vault$Vault$$cleanup$2(VaultSecret secret, Client client$3, Uri vaultUri$3, String clientToken$2, Concurrent evidence$9$1) {
        return ApplicativeErrorOps$.MODULE$.handleError$extension(implicits$.MODULE$.catsSyntaxApplicativeError(this.revokeLease((Client)client$3, vaultUri$3, clientToken$2, secret.renewal().leaseId(), (Sync)evidence$9$1), (ApplicativeError)evidence$9$1), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Throwable x$11) {
            }
        }, (ApplicativeError)evidence$9$1);
    }

    private Vault$() {
        MODULE$ = this;
        this.com$banno$vault$Vault$$decoderError = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InvalidMessageBodyFailure apply(DecodingFailure failure) {
                return new InvalidMessageBodyFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not decode JSON, error: ", ", cursor: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{failure.message(), failure.history()})), InvalidMessageBodyFailure$.MODULE$.apply$default$2());
            }
        };
    }
}

