/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator.dbcp;

import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.creator.dbcp.Dbcp2Config;
import com.baomidou.dynamic.datasource.toolkit.ConfigMergeCreator;
import com.baomidou.dynamic.datasource.toolkit.DsStrUtils;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

public class Dbcp2DataSourceCreator
implements DataSourceCreator {
    private static final ConfigMergeCreator<Dbcp2Config, BasicDataSource> MERGE_CREATOR = new ConfigMergeCreator<Dbcp2Config, BasicDataSource>("Dbcp2", Dbcp2Config.class, BasicDataSource.class);
    private Dbcp2Config gConfig;

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        BasicDataSource dataSource = MERGE_CREATOR.create(this.gConfig, dataSourceProperty.getDbcp2());
        dataSource.setUsername(dataSourceProperty.getUsername());
        dataSource.setPassword(dataSourceProperty.getPassword());
        dataSource.setUrl(dataSourceProperty.getUrl());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (DsStrUtils.hasText(driverClassName)) {
            dataSource.setDriverClassName(driverClassName);
        }
        if (Boolean.FALSE.equals(dataSourceProperty.getLazy())) {
            dataSource.start();
        }
        return dataSource;
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null || "org.apache.commons.dbcp2.BasicDataSource".equals(type.getName());
    }

    public Dbcp2DataSourceCreator() {
    }

    public Dbcp2DataSourceCreator(Dbcp2Config gConfig) {
        this.gConfig = gConfig;
    }
}

