/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure;

import cn.beecp.BeeDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.baomidou.dynamic.datasource.creator.atomikos.AtomikosDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.basic.BasicDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.beecp.BeeCpDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.dbcp.Dbcp2DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.druid.DruidDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.hikaricp.HikariDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.jndi.JndiDataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.tx.AtomikosTransactionFactory;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.transaction.TransactionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
public class DynamicDataSourceCreatorAutoConfiguration {
    public static final int JNDI_ORDER = 1000;
    public static final int DRUID_ORDER = 2000;
    public static final int HIKARI_ORDER = 3000;
    public static final int BEECP_ORDER = 4000;
    public static final int DBCP2_ORDER = 5000;
    public static final int ATOMIKOS_ORDER = 6000;
    public static final int DEFAULT_ORDER = 7000;

    @Bean
    @Order(value=7000)
    public BasicDataSourceCreator basicDataSourceCreator() {
        return new BasicDataSourceCreator();
    }

    @Bean
    @Order(value=1000)
    public JndiDataSourceCreator jndiDataSourceCreator() {
        return new JndiDataSourceCreator();
    }

    @ConditionalOnClass(value={AtomikosDataSourceBean.class, TransactionFactory.class})
    @Configuration
    static class AtomikosDataSourceCreatorConfiguration {
        AtomikosDataSourceCreatorConfiguration() {
        }

        @Bean
        @Order(value=6000)
        public AtomikosDataSourceCreator atomikosDataSourceCreator(DynamicDataSourceProperties properties) {
            return new AtomikosDataSourceCreator(properties.getAtomikos());
        }

        @Bean
        public TransactionFactory atomikosTransactionFactory() {
            return new AtomikosTransactionFactory();
        }
    }

    @ConditionalOnClass(value={BasicDataSource.class})
    @Configuration
    static class Dbcp2DataSourceCreatorConfiguration {
        Dbcp2DataSourceCreatorConfiguration() {
        }

        @Bean
        @Order(value=5000)
        public Dbcp2DataSourceCreator dbcp2DataSourceCreator(DynamicDataSourceProperties properties) {
            return new Dbcp2DataSourceCreator(properties.getDbcp2());
        }
    }

    @ConditionalOnClass(value={BeeDataSource.class})
    @Configuration
    static class BeeCpDataSourceCreatorConfiguration {
        BeeCpDataSourceCreatorConfiguration() {
        }

        @Bean
        @Order(value=4000)
        public BeeCpDataSourceCreator beeCpDataSourceCreator(DynamicDataSourceProperties properties) {
            return new BeeCpDataSourceCreator(properties.getBeecp());
        }
    }

    @ConditionalOnClass(value={HikariDataSource.class})
    @Configuration
    static class HikariDataSourceCreatorConfiguration {
        HikariDataSourceCreatorConfiguration() {
        }

        @Bean
        @Order(value=3000)
        public HikariDataSourceCreator hikariDataSourceCreator(DynamicDataSourceProperties properties) {
            return new HikariDataSourceCreator(properties.getHikari());
        }
    }

    @ConditionalOnClass(value={DruidDataSource.class})
    @Configuration
    static class DruidDataSourceCreatorConfiguration {
        DruidDataSourceCreatorConfiguration() {
        }

        @Bean
        @Order(value=2000)
        public DruidDataSourceCreator druidDataSourceCreator(DynamicDataSourceProperties properties) {
            return new DruidDataSourceCreator(properties.getDruid());
        }
    }
}

