/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicItemDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidDataSourceProperties;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicDataSourceProvider
implements DynamicDataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractDynamicDataSourceProvider.class);
    public static final String DRUID_DATASOURCE = "com.alibaba.druid.pool.DruidDataSource";
    public static final String HIKARI_DATASOURCE = "com.zaxxer.hikari.HikariDataSource";

    protected DataSource createDataSource(DynamicItemDataSource properties) {
        Class type = properties.getType();
        if (type == null) {
            try {
                Class.forName(DRUID_DATASOURCE);
                return this.createDruidDataSource(properties);
            }
            catch (ClassNotFoundException e) {
                log.debug("dynamic not found DruidDataSource");
                try {
                    Class.forName(HIKARI_DATASOURCE);
                    return this.createHikariDataSource(properties);
                }
                catch (ClassNotFoundException e2) {
                    log.debug("dynamic not found HikariDataSource");
                    throw new RuntimeException("please set master and slave type like spring.dynamic.datasource.master.type");
                }
            }
        }
        if (DRUID_DATASOURCE.equals(type.getName())) {
            return this.createDruidDataSource(properties);
        }
        return properties.initializeDataSourceBuilder().build();
    }

    private DataSource createHikariDataSource(DynamicItemDataSource properties) {
        properties.setType(HikariDataSource.class);
        return properties.initializeDataSourceBuilder().build();
    }

    private DataSource createDruidDataSource(DynamicItemDataSource properties) {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl(properties.getUrl());
        druidDataSource.setUsername(properties.getUsername());
        druidDataSource.setPassword(properties.getPassword());
        druidDataSource.setDriverClassName(properties.getDriverClassName());
        DruidDataSourceProperties druidProperties = properties.getDruid();
        druidDataSource.setInitialSize(druidProperties.getInitialSize());
        druidDataSource.setMaxActive(druidProperties.getMaxActive());
        druidDataSource.setMinIdle(druidProperties.getMinIdle());
        druidDataSource.setMaxWait(druidProperties.getMaxWait());
        druidDataSource.setTimeBetweenEvictionRunsMillis(druidProperties.getTimeBetweenEvictionRunsMillis());
        druidDataSource.setMinEvictableIdleTimeMillis(druidProperties.getMinEvictableIdleTimeMillis());
        druidDataSource.setMaxEvictableIdleTimeMillis(druidProperties.getMaxEvictableIdleTimeMillis());
        druidDataSource.setValidationQuery(druidProperties.getValidationQuery());
        druidDataSource.setValidationQueryTimeout(druidProperties.getValidationQueryTimeout());
        druidDataSource.setTestOnBorrow(druidProperties.isTestOnBorrow());
        druidDataSource.setTestOnReturn(druidProperties.isTestOnReturn());
        druidDataSource.setPoolPreparedStatements(druidProperties.isPoolPreparedStatements());
        druidDataSource.setMaxOpenPreparedStatements(druidProperties.getMaxOpenPreparedStatements());
        druidDataSource.setSharePreparedStatements(druidProperties.isSharePreparedStatements());
        druidDataSource.setConnectProperties(druidProperties.getConnectionProperties());
        try {
            druidDataSource.setFilters(druidProperties.getFilters());
            druidDataSource.init();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return druidDataSource;
    }
}

