/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import com.baomidou.dynamic.datasource.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.DynamicDataSourceStrategy;
import com.baomidou.dynamic.datasource.DynamicGroupDatasource;
import com.baomidou.dynamic.datasource.util.DynamicDataSourceContextHolder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicRoutingDataSource
extends AbstractRoutingDataSource {
    private static final Logger log = LoggerFactory.getLogger(DynamicRoutingDataSource.class);
    private Map<String, DataSource> dataSourceMap;
    private Map<String, DynamicGroupDatasource> groupDataSources = new HashMap<String, DynamicGroupDatasource>();
    private DynamicDataSourceProvider dynamicDataSourceProvider;
    private Class<? extends DynamicDataSourceStrategy> dynamicDataSourceStrategyClass;
    private String primary;

    protected Object determineCurrentLookupKey() {
        return DynamicDataSourceContextHolder.getDataSourceLookupKey();
    }

    protected DataSource determineTargetDataSource() {
        String lookupKey = (String)this.determineCurrentLookupKey();
        if (this.groupDataSources.containsKey(lookupKey)) {
            log.debug("\u4ece {} \u7ec4\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e\u6e90", (Object)lookupKey);
            return this.groupDataSources.get(lookupKey).determineDataSource();
        }
        if (this.dataSourceMap.containsKey(lookupKey)) {
            log.debug("\u4ece {} \u5355\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e\u6e90", (Object)lookupKey);
            return this.dataSourceMap.get(lookupKey);
        }
        log.debug("\u4ece\u9ed8\u8ba4\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e");
        return this.groupDataSources.containsKey(this.primary) ? this.groupDataSources.get(lookupKey).determineDataSource() : this.dataSourceMap.get(this.primary);
    }

    public void afterPropertiesSet() {
        this.dataSourceMap = this.dynamicDataSourceProvider.loadDataSources();
        log.debug("\u5171\u52a0\u8f7d {} \u4e2a\u6570\u636e\u6e90", (Object)this.dataSourceMap.size());
        for (Map.Entry<String, DataSource> dsItem : this.dataSourceMap.entrySet()) {
            String dsName = dsItem.getKey();
            if (!dsName.contains("_")) continue;
            String[] groupDs = dsName.split("_");
            String groupName = groupDs[0];
            DataSource dataSource = dsItem.getValue();
            if (this.groupDataSources.containsKey(groupName)) {
                this.groupDataSources.get(groupName).addDatasource(dataSource);
                continue;
            }
            try {
                DynamicGroupDatasource groupDatasource = new DynamicGroupDatasource(groupName, this.dynamicDataSourceStrategyClass.newInstance());
                groupDatasource.addDatasource(dataSource);
                this.groupDataSources.put(groupName, groupDatasource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator<Map.Entry<String, DynamicGroupDatasource>> groupIterator = this.groupDataSources.entrySet().iterator();
        while (groupIterator.hasNext()) {
            Map.Entry<String, DynamicGroupDatasource> item = groupIterator.next();
            log.debug("\u7ec4 {} \u4e0b\u6709 {} \u4e2a\u6570\u636e\u6e90", (Object)item.getKey(), (Object)item.getValue().size());
            if (item.getValue().size() != 1) continue;
            log.warn("\u8bf7\u6ce8\u610f\u4e0d\u8981\u8bbe\u7f6e\u4e00\u4e2a\u53ea\u6709\u4e00\u4e2a\u6570\u636e\u6e90\u7684\u7ec4\uff0c{} \u7ec4\u5c06\u88ab\u79fb\u9664", (Object)item.getKey());
            groupIterator.remove();
        }
        if (this.groupDataSources.containsKey(this.primary)) {
            log.debug("\u5f53\u524d\u7684\u9ed8\u8ba4\u6570\u636e\u6e90\u662f\u7ec4\u6570\u636e\u6e90,\u7ec4\u540d\u4e3a {} \uff0c\u5176\u4e0b\u6709 {} \u4e2a\u6570\u636e\u6e90", (Object)this.primary, (Object)this.groupDataSources.size());
        } else if (this.dataSourceMap.containsKey(this.primary)) {
            log.debug("\u5f53\u524d\u7684\u9ed8\u8ba4\u6570\u636e\u6e90\u662f\u5355\u6570\u636e\u6e90\uff0c\u6570\u636e\u6e90\u540d\u4e3a{}", (Object)this.primary);
        } else {
            throw new RuntimeException("\u8bf7\u68c0\u67e5primary\u9ed8\u8ba4\u6570\u636e\u5e93\u8bbe\u7f6e\uff0c\u5f53\u524d\u672a\u627e\u5230" + this.primary + "\u6570\u636e\u6e90");
        }
    }

    public void setDynamicDataSourceProvider(DynamicDataSourceProvider dynamicDataSourceProvider) {
        this.dynamicDataSourceProvider = dynamicDataSourceProvider;
    }

    public void setDynamicDataSourceStrategyClass(Class<? extends DynamicDataSourceStrategy> dynamicDataSourceStrategyClass) {
        this.dynamicDataSourceStrategyClass = dynamicDataSourceStrategyClass;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }
}

