/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.util.DynamicDataSourceContextHolder;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.AnnotationUtils;

public class DynamicDataSourceAnnotationInterceptor
implements MethodInterceptor {
    private static final Map<Method, String> METHOD_CACHE = new HashMap<Method, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            String datasource = this.determineDatasource(invocation);
            DynamicDataSourceContextHolder.setDataSourceLookupKey(datasource);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceLookupKey();
        }
    }

    private String determineDatasource(MethodInvocation invocation) {
        DS ds;
        Method method = invocation.getMethod();
        if (METHOD_CACHE.containsKey(method)) {
            return METHOD_CACHE.get(method);
        }
        DS dS = ds = method.isAnnotationPresent(DS.class) ? method.getAnnotation(DS.class) : (DS)AnnotationUtils.findAnnotation(method.getDeclaringClass(), DS.class);
        if (ds.value().isEmpty()) {
            throw new RuntimeException("2.0\u7248\u672c\u5fc5\u987b\u914d\u7f6e\u6bcf\u4e00\u4e2avalue");
        }
        METHOD_CACHE.put(method, ds.value());
        return ds.value();
    }
}

