/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.support.MybatisPlusResolver;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.AnnotationUtils;

public class DynamicDataSourceAnnotationInterceptor
implements MethodInterceptor {
    private static final Map<String, String> METHOD_CACHE = new HashMap<String, String>();
    private boolean mpEnabled;
    private MybatisPlusResolver mybatisPlusResolver;

    public DynamicDataSourceAnnotationInterceptor(boolean mpEnabled) {
        this.mpEnabled = mpEnabled;
        if (mpEnabled) {
            this.mybatisPlusResolver = new MybatisPlusResolver();
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            DynamicDataSourceContextHolder.setDataSourceLookupKey(this.determineDatasource(invocation));
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceLookupKey();
        }
    }

    private String determineDatasource(MethodInvocation invocation) throws Throwable {
        String cacheName;
        Method method = invocation.getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        if (this.mpEnabled) {
            declaringClass = this.mybatisPlusResolver.targetClass(invocation);
        }
        if (METHOD_CACHE.containsKey(cacheName = declaringClass.getName() + "." + method.getName())) {
            return METHOD_CACHE.get(cacheName);
        }
        DS ds = method.isAnnotationPresent(DS.class) ? method.getAnnotation(DS.class) : (DS)AnnotationUtils.findAnnotation(declaringClass, DS.class);
        METHOD_CACHE.put(cacheName, ds.value());
        return ds.value();
    }
}

