/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import com.baomidou.dynamic.datasource.AbstractRoutingDataSource;
import com.baomidou.dynamic.datasource.DynamicGroupDataSource;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.strategy.DynamicDataSourceStrategy;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DynamicRoutingDataSource
extends AbstractRoutingDataSource {
    private static final Logger log = LoggerFactory.getLogger(DynamicRoutingDataSource.class);
    private static final String UNDERLINE = "_";
    protected DynamicDataSourceProvider provider;
    protected Class<? extends DynamicDataSourceStrategy> strategy;
    protected String primary;
    private Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    private Map<String, DynamicGroupDataSource> groupDataSources = new ConcurrentHashMap<String, DynamicGroupDataSource>();

    @Override
    public DataSource determineDataSource() {
        return this.getDataSource(DynamicDataSourceContextHolder.getDataSourceLookupKey());
    }

    private DataSource determinePrimaryDataSource() {
        log.debug("\u4ece\u9ed8\u8ba4\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e");
        return this.groupDataSources.containsKey(this.primary) ? this.groupDataSources.get(this.primary).determineDataSource() : this.dataSourceMap.get(this.primary);
    }

    public Map<String, DataSource> getCurrentDataSources() {
        return this.dataSourceMap;
    }

    public Map<String, DynamicGroupDataSource> getCurrentGroupDataSources() {
        return this.groupDataSources;
    }

    public DataSource getDataSource(String ds) {
        if (StringUtils.isEmpty((Object)ds)) {
            return this.determinePrimaryDataSource();
        }
        if (!this.groupDataSources.isEmpty() && this.groupDataSources.containsKey(ds)) {
            log.debug("\u4ece {} \u7ec4\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e\u6e90", (Object)ds);
            return this.groupDataSources.get(ds).determineDataSource();
        }
        if (this.dataSourceMap.containsKey(ds)) {
            log.debug("\u4ece {} \u5355\u6570\u636e\u6e90\u4e2d\u8fd4\u56de\u6570\u636e\u6e90", (Object)ds);
            return this.dataSourceMap.get(ds);
        }
        return this.determinePrimaryDataSource();
    }

    public synchronized void addDataSource(String ds, DataSource dataSource) {
        this.dataSourceMap.put(ds, dataSource);
        if (ds.contains(UNDERLINE)) {
            String group = ds.split(UNDERLINE)[0];
            if (this.groupDataSources.containsKey(group)) {
                this.groupDataSources.get(group).addDatasource(dataSource);
            } else {
                try {
                    DynamicGroupDataSource groupDatasource = new DynamicGroupDataSource(group, this.strategy.newInstance());
                    groupDatasource.addDatasource(dataSource);
                    this.groupDataSources.put(group, groupDatasource);
                }
                catch (Exception e) {
                    log.error("\u6dfb\u52a0\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
                    this.dataSourceMap.remove(ds);
                }
            }
        }
        log.info("\u52a8\u6001\u6570\u636e\u6e90-\u52a0\u8f7d {} \u6210\u529f", (Object)ds);
    }

    public synchronized void removeDataSource(String ds) {
        if (this.dataSourceMap.containsKey(ds)) {
            String group;
            DataSource dataSource = this.dataSourceMap.get(ds);
            this.dataSourceMap.remove(ds);
            if (ds.contains(UNDERLINE) && this.groupDataSources.containsKey(group = ds.split(UNDERLINE)[0])) {
                this.groupDataSources.get(group).removeDatasource(dataSource);
            }
            log.info("\u52a8\u6001\u6570\u636e\u6e90-\u5220\u9664 {} \u6210\u529f", (Object)ds);
        } else {
            log.warn("\u52a8\u6001\u6570\u636e\u6e90-\u672a\u627e\u5230 {} \u6570\u636e\u6e90");
        }
    }

    public void init() {
        Map<String, DataSource> dataSources = this.provider.loadDataSources();
        log.info("\u521d\u59cb\u5171\u52a0\u8f7d {} \u4e2a\u6570\u636e\u6e90", (Object)dataSources.size());
        for (Map.Entry<String, DataSource> dsItem : dataSources.entrySet()) {
            this.addDataSource(dsItem.getKey(), dsItem.getValue());
        }
        if (this.groupDataSources.containsKey(this.primary)) {
            log.info("\u5f53\u524d\u7684\u9ed8\u8ba4\u6570\u636e\u6e90\u662f\u7ec4\u6570\u636e\u6e90,\u7ec4\u540d\u4e3a {} \uff0c\u5176\u4e0b\u6709 {} \u4e2a\u6570\u636e\u6e90", (Object)this.primary, (Object)this.groupDataSources.size());
        } else if (this.dataSourceMap.containsKey(this.primary)) {
            log.info("\u5f53\u524d\u7684\u9ed8\u8ba4\u6570\u636e\u6e90\u662f\u5355\u6570\u636e\u6e90\uff0c\u6570\u636e\u6e90\u540d\u4e3a {}", (Object)this.primary);
        } else {
            throw new RuntimeException("\u8bf7\u68c0\u67e5primary\u9ed8\u8ba4\u6570\u636e\u5e93\u8bbe\u7f6e");
        }
    }

    public void setProvider(DynamicDataSourceProvider provider) {
        this.provider = provider;
    }

    public void setStrategy(Class<? extends DynamicDataSourceStrategy> strategy) {
        this.strategy = strategy;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }
}

