/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.provider;

import com.baomidou.dynamic.datasource.DynamicDataSourceCreator;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.support.JdbcUtils;

public abstract class AbstractJdbcDataSourceProvider
implements DynamicDataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcDataSourceProvider.class);
    @Autowired(required=false)
    protected DynamicDataSourceProperties dynamicDataSourceProperties;
    @Autowired
    private DynamicDataSourceCreator dynamicDataSourceCreator;
    private String driverClassName;
    private String url;
    private String username;
    private String password;

    public AbstractJdbcDataSourceProvider(String driverClassName, String url, String username, String password) {
        this.driverClassName = driverClassName;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DataSource> loadDataSources() {
        block6: {
            HashMap<String, DataSource> hashMap;
            Connection conn = null;
            Statement stmt = null;
            try {
                Class.forName(this.driverClassName);
                log.info("\u6210\u529f\u52a0\u8f7d\u6570\u636e\u5e93\u9a71\u52a8\u7a0b\u5e8f");
                conn = DriverManager.getConnection(this.url, this.username, this.password);
                log.info("\u6210\u529f\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5");
                stmt = conn.createStatement();
                Map<String, DataSourceProperty> dataSourcePropertiesMap = this.executeStmt(stmt);
                HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(dataSourcePropertiesMap.size());
                for (Map.Entry<String, DataSourceProperty> item : dataSourcePropertiesMap.entrySet()) {
                    String pollName = item.getKey();
                    DataSourceProperty dataSourceProperty = item.getValue();
                    dataSourceProperty.setPollName(pollName);
                    dataSourceMap.put(pollName, this.dynamicDataSourceCreator.createDataSource(dataSourceProperty));
                }
                hashMap = dataSourceMap;
                JdbcUtils.closeConnection((Connection)conn);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                JdbcUtils.closeConnection(conn);
                JdbcUtils.closeStatement(stmt);
            }
            JdbcUtils.closeStatement((Statement)stmt);
            return hashMap;
        }
        return null;
    }

    protected abstract Map<String, DataSourceProperty> executeStmt(Statement var1) throws SQLException;
}

