/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.toolkit;

import java.util.ArrayDeque;
import java.util.Deque;
import org.springframework.util.StringUtils;

public final class DynamicDataSourceContextHolder {
    private static final ThreadLocal<Deque<String>> LOOKUP_KEY_HOLDER = new ThreadLocal(){

        protected Object initialValue() {
            return new ArrayDeque();
        }
    };

    private DynamicDataSourceContextHolder() {
    }

    public static String getDataSourceLookupKey() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static void setDataSourceLookupKey(String dataSourceLookupKey) {
        String ds = StringUtils.isEmpty((Object)dataSourceLookupKey) ? "" : dataSourceLookupKey;
        LOOKUP_KEY_HOLDER.get().push(ds);
    }

    public static void clearDataSourceLookupKey() {
        Deque<String> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }
}

