/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.hikari.HikariCpConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;

public class DynamicDataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceCreator.class);
    private static final String DRUID_DATASOURCE = "com.alibaba.druid.pool.DruidDataSource";
    private static final String HIKARI_DATASOURCE = "com.zaxxer.hikari.HikariDataSource";
    private static final JndiDataSourceLookup JNDI_DATA_SOURCE_LOOKUP = new JndiDataSourceLookup();
    private Method createMethod;
    private Method typeMethod;
    private Method urlMethod;
    private Method usernameMethod;
    private Method passwordMethod;
    private Method driverClassNameMethod;
    private Method buildMethod;
    private Boolean druidExists = false;
    private Boolean hikariExists = false;
    private DruidConfig druidGlobalConfig;
    private HikariCpConfig hikariGlobalConfig;

    public DynamicDataSourceCreator() {
        Class<?> builderClass = null;
        try {
            builderClass = Class.forName("org.springframework.boot.jdbc.DataSourceBuilder");
        }
        catch (Exception e) {
            try {
                builderClass = Class.forName("org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.createMethod = builderClass.getDeclaredMethod("create", new Class[0]);
            this.typeMethod = builderClass.getDeclaredMethod("type", Class.class);
            this.urlMethod = builderClass.getDeclaredMethod("url", String.class);
            this.usernameMethod = builderClass.getDeclaredMethod("username", String.class);
            this.passwordMethod = builderClass.getDeclaredMethod("password", String.class);
            this.driverClassNameMethod = builderClass.getDeclaredMethod("driverClassName", String.class);
            this.buildMethod = builderClass.getDeclaredMethod("build", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Class.forName(DRUID_DATASOURCE);
            log.info("\u52a8\u6001\u6570\u636e\u6e90-\u68c0\u6d4b\u5230druid\u5b58\u5728,\u5982\u914d\u7f6e\u4e2d\u672a\u6307\u5b9atype,druid\u4f1a\u9ed8\u8ba4\u914d\u7f6e");
            this.druidExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName(HIKARI_DATASOURCE);
            this.hikariExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        String jndiName = dataSourceProperty.getJndiName();
        if (jndiName != null && !jndiName.isEmpty()) {
            return this.createJNDIDataSource(jndiName);
        }
        Class<? extends DataSource> type = dataSourceProperty.getType();
        if (type == null) {
            if (this.druidExists.booleanValue()) {
                return this.createDruidDataSource(dataSourceProperty);
            }
            if (this.hikariExists.booleanValue()) {
                return this.createHikariDataSource(dataSourceProperty);
            }
        } else {
            if (DRUID_DATASOURCE.equals(type.getName())) {
                return this.createDruidDataSource(dataSourceProperty);
            }
            if (HIKARI_DATASOURCE.equals(type.getName())) {
                return this.createHikariDataSource(dataSourceProperty);
            }
        }
        return this.createBasicDataSource(dataSourceProperty);
    }

    public DataSource createBasicDataSource(DataSourceProperty dataSourceProperty) {
        try {
            Object o1 = this.createMethod.invoke(null, new Object[0]);
            Object o2 = this.typeMethod.invoke(o1, dataSourceProperty.getType());
            Object o3 = this.urlMethod.invoke(o2, dataSourceProperty.getUrl());
            Object o4 = this.usernameMethod.invoke(o3, dataSourceProperty.getUsername());
            Object o5 = this.passwordMethod.invoke(o4, dataSourceProperty.getPassword());
            Object o6 = this.driverClassNameMethod.invoke(o5, dataSourceProperty.getDriverClassName());
            return (DataSource)this.buildMethod.invoke(o6, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("\u591a\u6570\u636e\u6e90\u521b\u5efa\u6570\u636e\u6e90\u5931\u8d25");
        }
    }

    public DataSource createJNDIDataSource(String jndiName) {
        return JNDI_DATA_SOURCE_LOOKUP.getDataSource(jndiName);
    }

    public DataSource createDruidDataSource(DataSourceProperty dataSourceProperty) {
        Boolean breakAfterAcquireFailure;
        Integer connectionErrorRetryAttempts;
        Boolean sharePreparedStatements;
        Integer validationQueryTimeout;
        Boolean testOnReturn;
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUsername(dataSourceProperty.getUsername());
        dataSource.setPassword(dataSourceProperty.getPassword());
        dataSource.setUrl(dataSourceProperty.getUrl());
        dataSource.setDriverClassName(dataSourceProperty.getDriverClassName());
        dataSource.setName(dataSourceProperty.getPollName());
        DruidConfig config = dataSourceProperty.getDruid();
        Properties properties = config.toProperties(this.druidGlobalConfig);
        String filters = properties.getProperty("druid.filters");
        ArrayList<Object> proxyFilters = new ArrayList<Object>(2);
        if (!StringUtils.isEmpty((String)filters) && filters.contains("stat")) {
            StatFilter statFilter = new StatFilter();
            statFilter.configFromProperties(properties);
            proxyFilters.add(statFilter);
        }
        if (!StringUtils.isEmpty((String)filters) && filters.contains("wall")) {
            WallConfig wallConfig = dataSourceProperty.getDruid().getWall().toWallConfig(this.druidGlobalConfig.getWall());
            WallFilter wallFilter = new WallFilter();
            wallFilter.setConfig(wallConfig);
            proxyFilters.add(wallFilter);
        }
        dataSource.setProxyFilters(proxyFilters);
        dataSource.configFromPropety(properties);
        dataSource.setConnectProperties(config.getConnectionProperties());
        Boolean bl = testOnReturn = config.getTestOnReturn() == null ? this.druidGlobalConfig.getTestOnReturn() : config.getTestOnReturn();
        if (testOnReturn != null && testOnReturn.equals(true)) {
            dataSource.setTestOnReturn(true);
        }
        Integer n = validationQueryTimeout = config.getValidationQueryTimeout() == null ? this.druidGlobalConfig.getValidationQueryTimeout() : config.getValidationQueryTimeout();
        if (validationQueryTimeout != null && !validationQueryTimeout.equals(-1)) {
            dataSource.setValidationQueryTimeout(validationQueryTimeout.intValue());
        }
        Boolean bl2 = sharePreparedStatements = config.getSharePreparedStatements() == null ? this.druidGlobalConfig.getSharePreparedStatements() : config.getSharePreparedStatements();
        if (sharePreparedStatements != null && sharePreparedStatements.equals(true)) {
            dataSource.setSharePreparedStatements(true);
        }
        Integer n2 = connectionErrorRetryAttempts = config.getConnectionErrorRetryAttempts() == null ? this.druidGlobalConfig.getConnectionErrorRetryAttempts() : config.getConnectionErrorRetryAttempts();
        if (connectionErrorRetryAttempts != null && !connectionErrorRetryAttempts.equals(1)) {
            dataSource.setConnectionErrorRetryAttempts(connectionErrorRetryAttempts.intValue());
        }
        Boolean bl3 = breakAfterAcquireFailure = config.getBreakAfterAcquireFailure() == null ? this.druidGlobalConfig.getBreakAfterAcquireFailure() : config.getBreakAfterAcquireFailure();
        if (breakAfterAcquireFailure != null && breakAfterAcquireFailure.equals(true)) {
            dataSource.setBreakAfterAcquireFailure(true);
        }
        try {
            dataSource.init();
        }
        catch (SQLException e) {
            log.error("druid\u6570\u636e\u6e90\u542f\u52a8\u5931\u8d25", (Throwable)e);
        }
        return dataSource;
    }

    public DataSource createHikariDataSource(DataSourceProperty dataSourceProperty) {
        HikariCpConfig hikariCpConfig = dataSourceProperty.getHikari();
        HikariConfig config = hikariCpConfig.toHikariConfig(this.hikariGlobalConfig);
        config.setUsername(dataSourceProperty.getUsername());
        config.setPassword(dataSourceProperty.getPassword());
        config.setJdbcUrl(dataSourceProperty.getUrl());
        config.setDriverClassName(dataSourceProperty.getDriverClassName());
        config.setPoolName(dataSourceProperty.getPollName());
        return new HikariDataSource(config);
    }

    public void setDruidGlobalConfig(DruidConfig druidGlobalConfig) {
        this.druidGlobalConfig = druidGlobalConfig;
    }

    public void setHikariGlobalConfig(HikariCpConfig hikariGlobalConfig) {
        this.hikariGlobalConfig = hikariGlobalConfig;
    }
}

