/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.support.DbHealthIndicator;
import com.baomidou.dynamic.datasource.support.HealthCheckAdapter;
import javax.sql.DataSource;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DynamicDataSourceHealthCheckConfiguration {
    private static final String DYNAMIC_HEALTH_CHECK = "spring.datasource.dynamic.health";

    @Bean
    public HealthCheckAdapter healthCheckAdapter() {
        return new HealthCheckAdapter();
    }

    @ConditionalOnClass(value={AbstractHealthIndicator.class})
    @ConditionalOnEnabledHealthIndicator(value="dynamicDS")
    public class HealthIndicatorConfiguration {
        @Bean(value={"dynamicDataSourceHealthCheck"})
        @ConditionalOnProperty(value={"spring.datasource.dynamic.health"})
        public DbHealthIndicator healthIndicator(DataSource dataSource, DynamicDataSourceProperties dynamicDataSourceProperties, HealthCheckAdapter healthCheckAdapter) {
            return new DbHealthIndicator(dataSource, dynamicDataSourceProperties.getHealthValidQuery(), healthCheckAdapter);
        }
    }
}

