/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import cn.beecp.BeeDataSource;
import cn.beecp.BeeDataSourceConfig;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.beecp.BeeCpConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BeeCpDataSourceCreator
implements DataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(BeeCpDataSourceCreator.class);
    private static Boolean beeCpExists = false;
    private static Method copyToMethod = null;
    private BeeCpConfig beeCpConfig;

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        BeeDataSourceConfig config = dataSourceProperty.getBeecp().toBeeCpConfig(this.beeCpConfig);
        config.setUsername(dataSourceProperty.getUsername());
        config.setPassword(dataSourceProperty.getPassword());
        config.setJdbcUrl(dataSourceProperty.getUrl());
        config.setPoolName(dataSourceProperty.getPoolName());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (!StringUtils.isEmpty((Object)driverClassName)) {
            config.setDriverClassName(driverClassName);
        }
        if (!dataSourceProperty.getLazy().booleanValue()) {
            return new BeeDataSource(config);
        }
        BeeDataSource beeDataSource = new BeeDataSource();
        try {
            copyToMethod.invoke((Object)config, beeDataSource);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return beeDataSource;
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null && beeCpExists != false || type != null && "cn.beecp.BeeDataSource".equals(type.getName());
    }

    public BeeCpConfig getBeeCpConfig() {
        return this.beeCpConfig;
    }

    public void setBeeCpConfig(BeeCpConfig beeCpConfig) {
        this.beeCpConfig = beeCpConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeeCpDataSourceCreator)) {
            return false;
        }
        BeeCpDataSourceCreator other = (BeeCpDataSourceCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BeeCpConfig this$beeCpConfig = this.getBeeCpConfig();
        BeeCpConfig other$beeCpConfig = other.getBeeCpConfig();
        return !(this$beeCpConfig == null ? other$beeCpConfig != null : !((Object)this$beeCpConfig).equals(other$beeCpConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeeCpDataSourceCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BeeCpConfig $beeCpConfig = this.getBeeCpConfig();
        result = result * 59 + ($beeCpConfig == null ? 43 : ((Object)$beeCpConfig).hashCode());
        return result;
    }

    public String toString() {
        return "BeeCpDataSourceCreator(beeCpConfig=" + this.getBeeCpConfig() + ")";
    }

    public BeeCpDataSourceCreator(BeeCpConfig beeCpConfig) {
        this.beeCpConfig = beeCpConfig;
    }

    static {
        try {
            Class.forName("cn.beecp.BeeDataSource");
            beeCpExists = true;
            copyToMethod = BeeDataSourceConfig.class.getDeclaredMethod("copyTo", BeeDataSourceConfig.class);
            copyToMethod.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }
}

