/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.dbcp2.Dbcp2Config;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.dbcp2.Dbcp2Utils;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.util.StringUtils;

public class Dbcp2DataSourceCreator
implements DataSourceCreator {
    private static Boolean dbcp2Exists = false;
    private Dbcp2Config gConfig;

    public Dbcp2DataSourceCreator(Dbcp2Config gConfig) {
        this.gConfig = gConfig;
    }

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        BasicDataSource dataSource = Dbcp2Utils.createDataSource(this.gConfig, dataSourceProperty.getDbcp2());
        dataSource.setUsername(dataSourceProperty.getUsername());
        dataSource.setPassword(dataSourceProperty.getPassword());
        dataSource.setUrl(dataSourceProperty.getUrl());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (!StringUtils.isEmpty((Object)driverClassName)) {
            dataSource.setDriverClassName(driverClassName);
        }
        if (!dataSourceProperty.getLazy().booleanValue()) {
            dataSource.start();
        }
        return dataSource;
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null && dbcp2Exists != false || type != null && "org.apache.commons.dbcp2.BasicDataSource".equals(type.getName());
    }

    public Dbcp2Config getGConfig() {
        return this.gConfig;
    }

    public void setGConfig(Dbcp2Config gConfig) {
        this.gConfig = gConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dbcp2DataSourceCreator)) {
            return false;
        }
        Dbcp2DataSourceCreator other = (Dbcp2DataSourceCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Dbcp2Config this$gConfig = this.getGConfig();
        Dbcp2Config other$gConfig = other.getGConfig();
        return !(this$gConfig == null ? other$gConfig != null : !((Object)this$gConfig).equals(other$gConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Dbcp2DataSourceCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Dbcp2Config $gConfig = this.getGConfig();
        result = result * 59 + ($gConfig == null ? 43 : ((Object)$gConfig).hashCode());
        return result;
    }

    public String toString() {
        return "Dbcp2DataSourceCreator(gConfig=" + this.getGConfig() + ")";
    }

    static {
        try {
            Class.forName("org.apache.commons.dbcp2.BasicDataSource");
            dbcp2Exists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

