/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.baomidou.dynamic.datasource.creator.AbstractDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.hikari.HikariCpConfig;
import com.baomidou.dynamic.datasource.toolkit.ConfigMergeCreator;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class HikariDataSourceCreator
extends AbstractDataSourceCreator
implements DataSourceCreator,
InitializingBean {
    private static final ConfigMergeCreator<HikariCpConfig, HikariConfig> MERGE_CREATOR = new ConfigMergeCreator<HikariCpConfig, HikariConfig>("HikariCp", HikariCpConfig.class, HikariConfig.class);
    private static Method configCopyMethod = null;
    private HikariCpConfig gConfig;

    private static void fetchMethod() {
        try {
            configCopyMethod = HikariConfig.class.getMethod("copyState", HikariConfig.class);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                configCopyMethod = HikariConfig.class.getMethod("copyStateTo", HikariConfig.class);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("HikariConfig does not has 'copyState' or 'copyStateTo' method!");
            }
        }
    }

    @Override
    public DataSource doCreateDataSource(DataSourceProperty dataSourceProperty) {
        HikariConfig config = MERGE_CREATOR.create(this.gConfig, dataSourceProperty.getHikari());
        config.setUsername(dataSourceProperty.getUsername());
        config.setPassword(dataSourceProperty.getPassword());
        config.setJdbcUrl(dataSourceProperty.getUrl());
        config.setPoolName(dataSourceProperty.getPoolName());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (!StringUtils.isEmpty((Object)driverClassName)) {
            config.setDriverClassName(driverClassName);
        }
        if (Boolean.FALSE.equals(dataSourceProperty.getLazy())) {
            return new HikariDataSource(config);
        }
        config.validate();
        HikariDataSource dataSource = new HikariDataSource();
        try {
            configCopyMethod.invoke((Object)config, dataSource);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("HikariConfig failed to copy to HikariDataSource", e);
        }
        return dataSource;
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null || "com.zaxxer.hikari.HikariDataSource".equals(type.getName());
    }

    public void afterPropertiesSet() throws Exception {
        this.gConfig = this.properties.getHikari();
    }

    static {
        HikariDataSourceCreator.fetchMethod();
    }
}

