/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid;

import com.alibaba.druid.filter.logging.LogFilter;
import com.baomidou.dynamic.datasource.toolkit.DsConfigUtil;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DruidLogConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(DruidLogConfigUtil.class);
    private static final Map<String, Method> METHODS = DsConfigUtil.getSetterMethods(LogFilter.class);

    public static LogFilter initFilter(Class<? extends LogFilter> clazz, Map<String, Object> c, Map<String, Object> g) {
        try {
            LogFilter filter = clazz.newInstance();
            Map<String, Object> params = DsConfigUtil.mergeConfig(c, g);
            for (Map.Entry<String, Object> item : params.entrySet()) {
                String key = DsConfigUtil.lineToUpper(item.getKey());
                Method method = METHODS.get(key);
                if (method != null) {
                    try {
                        method.invoke((Object)filter, DsConfigUtil.convertValue(method, item.getValue()));
                    }
                    catch (Exception e) {
                        log.warn("druid {} set param {} error", new Object[]{clazz.getName(), key, e});
                    }
                    continue;
                }
                log.warn("druid {} does not have param {}", (Object)clazz.getName(), (Object)key);
            }
            return filter;
        }
        catch (Exception e) {
            return null;
        }
    }
}

