/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.creator.DatasourceInitProperties;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.enums.SeataMode;
import com.baomidou.dynamic.datasource.event.DataSourceInitEvent;
import com.baomidou.dynamic.datasource.support.ScriptRunner;
import com.p6spy.engine.spy.P6DataSource;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.xa.DataSourceProxyXA;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultDataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataSourceCreator.class);
    private List<DataSourceCreator> creators;
    private Boolean lazy = false;
    private Boolean p6spy = false;
    private Boolean seata = false;
    private SeataMode seataMode = SeataMode.AT;
    private String publicKey = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAJ4o6sn4WoPmbs7DR9mGQzuuUQM9erQTVPpwxIzB0ETYkyKffO097qXVRLA6KPmaV+/siWewR7vpfYYjWajw5KkCAwEAAQ==";
    private DataSourceInitEvent dataSourceInitEvent;

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        Boolean propertyLazy;
        DataSourceCreator dataSourceCreator = null;
        for (DataSourceCreator creator : this.creators) {
            if (!creator.support(dataSourceProperty)) continue;
            dataSourceCreator = creator;
            break;
        }
        if (dataSourceCreator == null) {
            throw new IllegalStateException("creator must not be null,please check the DataSourceCreator");
        }
        String propertyPublicKey = dataSourceProperty.getPublicKey();
        if (StringUtils.isEmpty((Object)propertyPublicKey)) {
            dataSourceProperty.setPublicKey(this.publicKey);
        }
        if ((propertyLazy = dataSourceProperty.getLazy()) == null) {
            dataSourceProperty.setLazy(this.lazy);
        }
        if (this.dataSourceInitEvent != null) {
            this.dataSourceInitEvent.beforeCreate(dataSourceProperty);
        }
        DataSource dataSource = dataSourceCreator.createDataSource(dataSourceProperty);
        if (this.dataSourceInitEvent != null) {
            this.dataSourceInitEvent.afterCreate(dataSource);
        }
        this.runScrip(dataSource, dataSourceProperty);
        return this.wrapDataSource(dataSource, dataSourceProperty);
    }

    private void runScrip(DataSource dataSource, DataSourceProperty dataSourceProperty) {
        DatasourceInitProperties initProperty = dataSourceProperty.getInit();
        String schema = initProperty.getSchema();
        String data = initProperty.getData();
        if (StringUtils.hasText((String)schema) || StringUtils.hasText((String)data)) {
            ScriptRunner scriptRunner = new ScriptRunner(initProperty.isContinueOnError(), initProperty.getSeparator());
            if (StringUtils.hasText((String)schema)) {
                scriptRunner.runScript(dataSource, schema);
            }
            if (StringUtils.hasText((String)data)) {
                scriptRunner.runScript(dataSource, data);
            }
        }
    }

    private DataSource wrapDataSource(DataSource dataSource, DataSourceProperty dataSourceProperty) {
        Boolean enabledSeata;
        String name = dataSourceProperty.getPoolName();
        DataSource targetDataSource = dataSource;
        Boolean enabledP6spy = this.p6spy != false && dataSourceProperty.getP6spy() != false;
        if (enabledP6spy.booleanValue()) {
            targetDataSource = new P6DataSource(dataSource);
            log.debug("dynamic-datasource [{}] wrap p6spy plugin", (Object)name);
        }
        if ((enabledSeata = Boolean.valueOf(this.seata != false && dataSourceProperty.getSeata() != false)).booleanValue()) {
            targetDataSource = SeataMode.XA == this.seataMode ? new DataSourceProxyXA(targetDataSource) : new DataSourceProxy(targetDataSource);
            log.debug("dynamic-datasource [{}] wrap seata plugin transaction mode ", (Object)name);
        }
        return new ItemDataSource(name, dataSource, targetDataSource, enabledP6spy, enabledSeata, this.seataMode);
    }

    public void setCreators(List<DataSourceCreator> creators) {
        this.creators = creators;
    }

    public void setLazy(Boolean lazy) {
        this.lazy = lazy;
    }

    public void setP6spy(Boolean p6spy) {
        this.p6spy = p6spy;
    }

    public void setSeata(Boolean seata) {
        this.seata = seata;
    }

    public void setSeataMode(SeataMode seataMode) {
        this.seataMode = seataMode;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setDataSourceInitEvent(DataSourceInitEvent dataSourceInitEvent) {
        this.dataSourceInitEvent = dataSourceInitEvent;
    }
}

