/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.provider;

import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.provider.AbstractDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractJdbcDataSourceProvider
extends AbstractDataSourceProvider
implements DynamicDataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcDataSourceProvider.class);
    private final String driverClassName;
    private final String url;
    private final String username;
    private final String password;

    public AbstractJdbcDataSourceProvider(DefaultDataSourceCreator defaultDataSourceCreator, String url, String username, String password) {
        this(defaultDataSourceCreator, null, url, username, password);
    }

    public AbstractJdbcDataSourceProvider(DefaultDataSourceCreator defaultDataSourceCreator, String driverClassName, String url, String username, String password) {
        super(defaultDataSourceCreator);
        this.driverClassName = driverClassName;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    private static void closeResource(AutoCloseable con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                log.debug("Could not close ", (Throwable)ex);
            }
            catch (Throwable ex) {
                log.debug("Unexpected exception on closing", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DataSource> loadDataSources() {
        block6: {
            Map<String, DataSource> map;
            Connection conn = null;
            Statement stmt = null;
            try {
                if (!StringUtils.isEmpty((Object)this.driverClassName)) {
                    Class.forName(this.driverClassName);
                    log.info("\u6210\u529f\u52a0\u8f7d\u6570\u636e\u5e93\u9a71\u52a8\u7a0b\u5e8f");
                }
                conn = DriverManager.getConnection(this.url, this.username, this.password);
                log.info("\u6210\u529f\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5");
                stmt = conn.createStatement();
                Map<String, DataSourceProperty> dataSourcePropertiesMap = this.executeStmt(stmt);
                map = this.createDataSourceMap(dataSourcePropertiesMap);
                AbstractJdbcDataSourceProvider.closeResource(conn);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                AbstractJdbcDataSourceProvider.closeResource(conn);
                AbstractJdbcDataSourceProvider.closeResource(stmt);
            }
            AbstractJdbcDataSourceProvider.closeResource(stmt);
            return map;
        }
        return null;
    }

    protected abstract Map<String, DataSourceProperty> executeStmt(Statement var1) throws SQLException;
}

