/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.tx;

import com.baomidou.dynamic.datasource.tx.ConnectionProxy;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.Savepoint;
import java.util.LinkedList;
import java.util.List;

public class SavePointHolder {
    private static final String SAVEPOINT_NAME_PREFIX = "DYNAMIC_";
    private ConnectionProxy connectionProxy;
    private LinkedList<Savepoint> savepoints;

    public SavePointHolder(ConnectionProxy connectionProxy) {
        this.connectionProxy = connectionProxy;
        this.savepoints = new LinkedList();
    }

    public void conversionSavePointHolder() throws SQLException {
        if (this.connectionProxy == null) {
            throw new SQLTransientConnectionException();
        }
        int savepointCounter = this.connectionProxy.getSavepointCounter();
        Savepoint savepoint = this.connectionProxy.setSavepoint(SAVEPOINT_NAME_PREFIX + savepointCounter);
        this.connectionProxy.setSavepointCounter(savepointCounter + 1);
        this.savepoints.addLast(savepoint);
    }

    public int releaseSavepoint() throws SQLException {
        Savepoint savepoint = this.savepoints.pollLast();
        if (savepoint != null) {
            this.connectionProxy.releaseSavepoint(savepoint);
            String savepointName = savepoint.getSavepointName();
            return Integer.parseInt(savepointName.substring(SAVEPOINT_NAME_PREFIX.length()));
        }
        return -1;
    }

    public int rollbackSavePoint() throws SQLException {
        Savepoint savepoint = this.savepoints.pollLast();
        if (savepoint != null) {
            this.connectionProxy.rollback(savepoint);
            String savepointName = savepoint.getSavepointName();
            return Integer.parseInt(savepointName.substring(SAVEPOINT_NAME_PREFIX.length()));
        }
        return -1;
    }

    public ConnectionProxy getConnectionProxy() {
        return this.connectionProxy;
    }

    public List<Savepoint> getSavePoints() {
        return this.savepoints;
    }
}

