/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.lock.executor;

import com.baomidou.lock.executor.AbstractLockExecutor;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisTemplateLockExecutor
extends AbstractLockExecutor<String> {
    private static final Logger log = LoggerFactory.getLogger(RedisTemplateLockExecutor.class);
    private static final RedisScript<String> SCRIPT_LOCK = new DefaultRedisScript("return redis.call('set',KEYS[1],ARGV[1],'NX','PX',ARGV[2])", String.class);
    private static final RedisScript<String> SCRIPT_UNLOCK = new DefaultRedisScript("if redis.call('get',KEYS[1]) == ARGV[1] then return tostring(redis.call('del', KEYS[1])==1) else return 'false' end", String.class);
    private static final String LOCK_SUCCESS = "OK";
    private final StringRedisTemplate redisTemplate;

    public String acquire(String lockKey, String lockValue, long expire, long acquireTimeout) {
        String lock = (String)this.redisTemplate.execute(SCRIPT_LOCK, this.redisTemplate.getStringSerializer(), this.redisTemplate.getStringSerializer(), Collections.singletonList(lockKey), new Object[]{lockValue, String.valueOf(expire)});
        boolean locked = LOCK_SUCCESS.equals(lock);
        return (String)this.obtainLockInstance(locked, lock);
    }

    public boolean releaseLock(String key, String value, String lockInstance) {
        String releaseResult = (String)this.redisTemplate.execute(SCRIPT_UNLOCK, this.redisTemplate.getStringSerializer(), this.redisTemplate.getStringSerializer(), Collections.singletonList(key), new Object[]{value});
        return Boolean.parseBoolean(releaseResult);
    }

    public RedisTemplateLockExecutor(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

