/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.sharding;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.sql.DataSource;
import mybatis.mate.config.DataSourceProperty;
import mybatis.mate.config.ShardingGroupProperty;
import mybatis.mate.sharding.O00000o0;
import mybatis.mate.sharding.ShardingDatasource;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.CollectionUtils;

public class ShardingHealthIndicator
extends AbstractHealthIndicator {
    private final ShardingDatasource shardingDatasource;

    public ShardingHealthIndicator(ShardingDatasource shardingDatasource) {
        this.shardingDatasource = shardingDatasource;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Map<String, ShardingGroupProperty> map = O00000o0.O0000oo();
        AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        map.forEach((string, shardingGroupProperty) -> {
            ShardingGroupProperty shardingGroupProperty2 = this.checkDbGroupProperty((String)string, (ShardingGroupProperty)shardingGroupProperty);
            O00000o0.O000000o(string, shardingGroupProperty2);
            if (atomicBoolean.get() && shardingGroupProperty2.isHealth()) {
                atomicBoolean.set(false);
            }
            builder.withDetail(string, (Object)shardingGroupProperty2.isHealth());
        });
        builder.status(atomicBoolean.get() ? Status.DOWN : Status.UP);
    }

    protected ShardingGroupProperty checkDbGroupProperty(String string, ShardingGroupProperty shardingGroupProperty) {
        ShardingGroupProperty shardingGroupProperty2 = new ShardingGroupProperty();
        Map<String, DataSource> map = this.shardingDatasource.getDataSources();
        this.checkDbKeys(string, shardingGroupProperty.getMasterKeys(), map::get, shardingGroupProperty2::setMasterKeys);
        this.checkDbKeys(string, shardingGroupProperty.getSlaveKeys(), map::get, shardingGroupProperty2::setSlaveKeys);
        return shardingGroupProperty2;
    }

    protected void checkDbKeys(String string, List<String> list, Function<String, DataSource> function, Consumer<List<String>> consumer) {
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : list) {
                String string3 = string + string2;
                DataSource dataSource = function.apply(string3);
                if (null == dataSource || !this.queryAvailable(string3, dataSource)) continue;
                arrayList.add(string2);
            }
            if (!CollectionUtils.isEmpty(arrayList)) {
                consumer.accept(arrayList);
            }
        }
    }

    protected boolean queryAvailable(String string, DataSource dataSource) {
        try {
            DataSourceProperty dataSourceProperty = this.shardingDatasource.getDataSourcePropertyByKey(string);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            jdbcTemplate.setQueryTimeout(10);
            List list = new JdbcTemplate(dataSource).query(dataSourceProperty.getTestQuery(), (resultSet, n) -> {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                if (n2 != 1) {
                    throw new IncorrectResultSetColumnCountException(1, n2);
                }
                return (Integer)JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)1, Integer.class);
            });
            return (Integer)DataAccessUtils.requiredSingleResult((Collection)list) == 1;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

