/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.autoconfigure;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import mybatis.mate.O00000o0.O0000o0O;
import mybatis.mate.config.CertProperties;
import mybatis.mate.config.DataSourceProperty;
import mybatis.mate.config.ShardingProperties;
import mybatis.mate.license.IGrantSupplier;
import mybatis.mate.provider.HikariDataSourceProvider;
import mybatis.mate.provider.IDataSourceProvider;
import mybatis.mate.sharding.IShardingProcessor;
import mybatis.mate.sharding.O000000o;
import mybatis.mate.sharding.O00000oO;
import mybatis.mate.sharding.ShardingDatasource;
import mybatis.mate.sharding.ShardingHealthIndicator;
import mybatis.mate.strategy.IShardingStrategy;
import org.apache.ibatis.transaction.TransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.XADataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;

@Lazy
@Configuration(proxyBeanMethods=false)
@AutoConfigureOrder(value=-2147483643)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class, XADataSourceAutoConfiguration.class})
@ConditionalOnProperty(prefix="mybatis-mate.sharding", name={"primary"})
public class O00000Oo {
    private static final Logger log = LoggerFactory.getLogger(O00000Oo.class);
    @Autowired
    private ShardingProperties shardingProperties;
    @Autowired
    private CertProperties certProperties;
    @Autowired(required=false)
    private IGrantSupplier grantSupplier;
    private IShardingStrategy shardingStrategy;

    @Autowired(required=false)
    public void setShardingStrategy(IShardingStrategy iShardingStrategy) {
        this.shardingStrategy = iShardingStrategy;
    }

    @Bean
    @ConditionalOnMissingBean
    public IDataSourceProvider dataSourceProvider() {
        return new HikariDataSourceProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public IShardingProcessor shardingProcessor() {
        return new O000000o();
    }

    @Primary
    @Bean(name={"dataSource"})
    @ConditionalOnMissingBean
    public ShardingDatasource shardingDatasource(IDataSourceProvider iDataSourceProvider) {
        Map<String, List<DataSourceProperty>> map = this.shardingProperties.getDatasource();
        mybatis.mate.O000000o.O000000o.O000000o(O0000o0O.O000000o(map), "datasource can't be empty!");
        mybatis.mate.O000000o.O000000o.O000000o(O0000o0O.O00000Oo((CharSequence)this.shardingProperties.getPrimary()), "primary datasource can't be empty!");
        ConcurrentHashMap<String, DataSource> concurrentHashMap = new ConcurrentHashMap<String, DataSource>(16);
        ConcurrentHashMap<String, DataSourceProperty> concurrentHashMap2 = new ConcurrentHashMap<String, DataSourceProperty>(16);
        map.forEach((string, list) -> list.forEach(dataSourceProperty -> {
            mybatis.mate.O000000o.O000000o.O000000o(O0000o0O.O00000Oo((CharSequence)dataSourceProperty.getKey()), "datasource key can't be empty!");
            String string2 = string + dataSourceProperty.getKey();
            mybatis.mate.O000000o.O000000o.O000000o(null != concurrentHashMap.get(string2), "datasource key repetition is not allowed!");
            try {
                concurrentHashMap.put(string2, iDataSourceProvider.createDataSource((String)string, (DataSourceProperty)dataSourceProperty));
                concurrentHashMap2.put(string2, (DataSourceProperty)dataSourceProperty);
            }
            catch (SQLException sQLException) {
                mybatis.mate.O000000o.O000000o.O000000o(sQLException);
            }
        }));
        if (null != this.shardingStrategy) {
            this.shardingProperties.setShardingStrategy(this.shardingStrategy);
        }
        return new ShardingDatasource(iDataSourceProvider, concurrentHashMap, concurrentHashMap2, this.shardingProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public TransactionFactory transactionFactory() {
        O0000o0O.O000000o(this.certProperties.getGrant(this.grantSupplier), this.certProperties.getLicense(), bl -> mybatis.mate.O000000o.O000000o.O000000o(bl));
        return new O00000oO();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="mybatis-mate.sharding", name={"health"}, havingValue="true")
    public ShardingHealthIndicator shardingHealthIndicator(ShardingDatasource shardingDatasource) {
        log.debug("Datasource Health check started.");
        return new ShardingHealthIndicator(shardingDatasource);
    }
}

