/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.parser.tenant;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.parser.AbstractJsqlParser;
import com.baomidou.mybatisplus.plugins.parser.tenant.TenantHandler;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;

public class TenantSqlParser
extends AbstractJsqlParser {
    private TenantHandler tenantHandler;

    @Override
    public void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                this.processSelectBody(withItem.getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List plainSelects = operationList.getSelects();
                for (SelectBody plainSelect : plainSelects) {
                    this.processSelectBody(plainSelect);
                }
            }
        }
    }

    @Override
    public void processInsert(Insert insert) {
        if (this.tenantHandler.doTableFilter(insert.getTable().getName())) {
            return;
        }
        insert.getColumns().add(new Column(this.tenantHandler.getTenantIdColumn()));
        if (insert.getSelect() != null) {
            this.processPlainSelect((PlainSelect)insert.getSelect().getSelectBody(), true);
        } else if (insert.getItemsList() != null) {
            ((ExpressionList)insert.getItemsList()).getExpressions().add(this.tenantHandler.getTenantId());
        } else {
            throw new MybatisPlusException("Failed to process multiple-table update, please exclude the tableName or statementId");
        }
    }

    @Override
    public void processUpdate(Update update) {
        List tableList = update.getTables();
        if (null == tableList || tableList.size() >= 2) {
            throw new MybatisPlusException("Failed to process multiple-table update, please exclude the statementId");
        }
        Table table = (Table)tableList.get(0);
        if (this.tenantHandler.doTableFilter(table.getName())) {
            return;
        }
        update.setWhere((Expression)this.andExpression(table, update.getWhere()));
    }

    @Override
    public void processDelete(Delete delete) {
        if (this.tenantHandler.doTableFilter(delete.getTable().getName())) {
            return;
        }
        delete.setWhere((Expression)this.andExpression(delete.getTable(), delete.getWhere()));
    }

    protected BinaryExpression andExpression(Table table, Expression where) {
        EqualsTo equalsTo = new EqualsTo();
        if (null != where) {
            equalsTo.setLeftExpression((Expression)new Column(this.tenantHandler.getTenantIdColumn()));
            equalsTo.setRightExpression(this.tenantHandler.getTenantId());
            return new AndExpression((Expression)equalsTo, where);
        }
        equalsTo.setLeftExpression((Expression)this.getAliasColumn(table));
        equalsTo.setRightExpression(this.tenantHandler.getTenantId());
        return equalsTo;
    }

    protected void processPlainSelect(PlainSelect plainSelect) {
        this.processPlainSelect(plainSelect, false);
    }

    protected void processPlainSelect(PlainSelect plainSelect, boolean addColumn) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (this.tenantHandler.doTableFilter(fromTable.getName())) {
                return;
            }
            plainSelect.setWhere(this.builderExpression(plainSelect.getWhere(), fromTable));
            if (addColumn) {
                plainSelect.getSelectItems().add(new SelectExpressionItem((Expression)new Column(this.tenantHandler.getTenantIdColumn())));
            }
        } else {
            this.processFromItem(fromItem);
        }
        List joins = plainSelect.getJoins();
        if (joins != null && joins.size() > 0) {
            for (Join join : joins) {
                this.processJoin(join);
                this.processFromItem(join.getRightItem());
            }
        }
    }

    protected void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoin() != null) {
                this.processJoin(subJoin.getJoin());
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (fromItem instanceof ValuesList) {
            this.logger.debug("Perform a subquery, if you do not give us feedback");
        } else if (fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    protected void processJoin(Join join) {
        if (join.getRightItem() instanceof Table) {
            Table fromTable = (Table)join.getRightItem();
            if (this.tenantHandler.doTableFilter(fromTable.getName())) {
                return;
            }
            join.setOnExpression(this.builderExpression(join.getOnExpression(), fromTable));
        }
    }

    protected Expression builderExpression(Expression expression, Table table) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)this.getAliasColumn(table));
        equalsTo.setRightExpression(this.tenantHandler.getTenantId());
        if (expression == null) {
            return equalsTo;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.getLeftExpression() instanceof FromItem) {
                this.processFromItem((FromItem)binaryExpression.getLeftExpression());
            }
            if (binaryExpression.getRightExpression() instanceof FromItem) {
                this.processFromItem((FromItem)binaryExpression.getRightExpression());
            }
        }
        return new AndExpression((Expression)equalsTo, expression);
    }

    protected Column getAliasColumn(Table table) {
        if (null == table.getAlias()) {
            return new Column(this.tenantHandler.getTenantIdColumn());
        }
        StringBuilder column = new StringBuilder();
        column.append(table.getAlias().getName());
        column.append(".");
        column.append(this.tenantHandler.getTenantIdColumn());
        return new Column(column.toString());
    }

    public TenantHandler getTenantHandler() {
        return this.tenantHandler;
    }

    public void setTenantHandler(TenantHandler tenantHandler) {
        this.tenantHandler = tenantHandler;
    }
}

