/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.entity.TableFieldInfo;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.enums.SqlMethod;
import com.baomidou.mybatisplus.mapper.AutoSqlInjector;
import com.baomidou.mybatisplus.toolkit.SqlReservedWords;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.defaults.RawSqlSource;

public class LogicSqlInjector
extends AutoSqlInjector {
    protected void injectDeleteByIdSql(boolean batch, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        if (table.isLogicDelete()) {
            SqlMethod sqlMethod = SqlMethod.LOGIC_DELETE_BY_ID;
            String idStr = table.getKeyProperty();
            if (batch) {
                sqlMethod = SqlMethod.LOGIC_DELETE_BATCH_BY_IDS;
                StringBuilder ids = new StringBuilder();
                ids.append("\n<foreach item=\"item\" index=\"index\" collection=\"list\" separator=\",\">");
                ids.append("#{item}");
                ids.append("\n</foreach>");
                idStr = ids.toString();
            }
            String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlLogicSet(table), table.getKeyColumn(), idStr);
            SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
            this.addUpdateMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource);
        } else {
            super.injectDeleteByIdSql(batch, mapperClass, modelClass, table);
        }
    }

    protected void injectDeleteSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        if (table.isLogicDelete()) {
            SqlMethod sqlMethod = SqlMethod.LOGIC_DELETE;
            String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlLogicSet(table), this.sqlWhereEntityWrapper(table));
            SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
            this.addUpdateMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource);
        } else {
            super.injectDeleteSql(mapperClass, modelClass, table);
        }
    }

    protected void injectDeleteByMapSql(Class<?> mapperClass, TableInfo table) {
        if (table.isLogicDelete()) {
            SqlMethod sqlMethod = SqlMethod.LOGIC_DELETE_BY_MAP;
            String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlLogicSet(table), this.sqlWhereByMap(table));
            SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, Map.class);
            this.addUpdateMappedStatement(mapperClass, Map.class, sqlMethod.getMethod(), sqlSource);
        } else {
            super.injectDeleteByMapSql(mapperClass, table);
        }
    }

    protected void injectSelectByIdSql(boolean batch, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        if (table.isLogicDelete()) {
            RawSqlSource sqlSource;
            SqlMethod sqlMethod = SqlMethod.LOGIC_SELECT_BY_ID;
            if (batch) {
                sqlMethod = SqlMethod.LOGIC_SELECT_BATCH_BY_IDS;
                StringBuilder ids = new StringBuilder();
                ids.append("\n<foreach item=\"item\" index=\"index\" collection=\"list\" separator=\",\">");
                ids.append("#{item}");
                ids.append("\n</foreach>");
                sqlSource = this.languageDriver.createSqlSource(this.configuration, String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, false), table.getTableName(), table.getKeyColumn(), ids.toString(), this.getLogicDeleteSql(table)), modelClass);
            } else {
                sqlSource = new RawSqlSource(this.configuration, String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, false), table.getTableName(), table.getKeyColumn(), table.getKeyProperty(), this.getLogicDeleteSql(table)), Object.class);
            }
            this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), (SqlSource)sqlSource, modelClass, table);
        } else {
            super.injectSelectByIdSql(batch, mapperClass, modelClass, table);
        }
    }

    protected void injectUpdateByIdSql(boolean selective, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        if (table.isLogicDelete()) {
            SqlMethod sqlMethod = selective ? SqlMethod.LOGIC_UPDATE_BY_ID : SqlMethod.LOGIC_UPDATE_ALL_COLUMN_BY_ID;
            String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlSet(selective, table, "et."), table.getKeyColumn(), "et." + table.getKeyProperty(), "<if test=\"et instanceof java.util.Map\"><if test=\"et.MP_OPTLOCK_VERSION_ORIGINAL!=null\">and ${et.MP_OPTLOCK_VERSION_COLUMN}=#{et.MP_OPTLOCK_VERSION_ORIGINAL}</if></if>" + this.getLogicDeleteSql(table));
            SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
            this.addUpdateMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource);
        } else {
            super.injectUpdateByIdSql(selective, mapperClass, modelClass, table);
        }
    }

    public String getLogicDeleteSql(TableInfo table) {
        StringBuilder sql = new StringBuilder();
        List fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            if (!fieldInfo.isLogicDelete()) continue;
            sql.append(" AND ").append(fieldInfo.getColumn());
            if (StringUtils.isCharSequence((Class)fieldInfo.getPropertyType()).booleanValue()) {
                sql.append("='").append(fieldInfo.getLogicNotDeleteValue()).append("'");
                continue;
            }
            sql.append("=").append(fieldInfo.getLogicNotDeleteValue());
        }
        return sql.toString();
    }

    protected String sqlLogicSet(TableInfo table) {
        List fieldList = table.getFieldList();
        StringBuilder set = new StringBuilder("SET ");
        int i = 0;
        for (TableFieldInfo fieldInfo : fieldList) {
            if (!fieldInfo.isLogicDelete()) continue;
            if (++i > 1) {
                set.append(",");
            }
            set.append(fieldInfo.getColumn()).append("=");
            if (StringUtils.isCharSequence((Class)fieldInfo.getPropertyType()).booleanValue()) {
                set.append("'").append(fieldInfo.getLogicDeleteValue()).append("'");
                continue;
            }
            set.append(fieldInfo.getLogicDeleteValue());
        }
        return set.toString();
    }

    protected String sqlWhere(TableInfo table) {
        if (table.isLogicDelete()) {
            StringBuilder where = new StringBuilder("\n<where>");
            List fieldList = table.getFieldList();
            if (StringUtils.isNotEmpty((CharSequence)table.getKeyProperty())) {
                where.append("\n<if test=\"ew.").append(table.getKeyProperty()).append("!=null\">");
                where.append(" AND ").append(table.getKeyColumn()).append("=#{ew.");
                where.append(table.getKeyProperty()).append("}");
                where.append("</if>");
            }
            for (TableFieldInfo fieldInfo : fieldList) {
                where.append(this.convertIfTag(fieldInfo, "ew.", false));
                where.append(" AND ").append(fieldInfo.getColumn()).append("=#{ew.");
                where.append(fieldInfo.getEl()).append("}");
                where.append(this.convertIfTag(fieldInfo, true));
            }
            where.append("\n").append(this.getLogicDeleteSql(table));
            where.append("\n</where>");
            return where.toString();
        }
        return super.sqlWhere(table);
    }

    protected String sqlWhereEntityWrapper(TableInfo table) {
        if (table.isLogicDelete()) {
            StringBuilder where = new StringBuilder(128);
            where.append("\n<where>");
            where.append("\n<if test=\"ew!=null\">");
            where.append("\n<if test=\"ew.entity!=null\">");
            if (StringUtils.isNotEmpty((CharSequence)table.getKeyProperty())) {
                where.append("\n<if test=\"ew.entity.").append(table.getKeyProperty()).append("!=null\">");
                where.append(" AND ").append(table.getKeyColumn()).append("=#{ew.entity.");
                where.append(table.getKeyProperty()).append("}");
                where.append("</if>");
            }
            List fieldList = table.getFieldList();
            for (TableFieldInfo fieldInfo : fieldList) {
                where.append(this.convertIfTag(fieldInfo, "ew.entity.", false));
                where.append(" AND ").append(fieldInfo.getColumn()).append("=#{ew.entity.");
                where.append(fieldInfo.getEl()).append("}");
                where.append(this.convertIfTag(fieldInfo, true));
            }
            where.append("\n</if>");
            where.append("\n").append(this.getLogicDeleteSql(table));
            where.append("\n<if test=\"ew.sqlSegment!=null\">${ew.sqlSegment}\n</if>");
            where.append("\n</if>");
            where.append("\n</where>");
            return where.toString();
        }
        return super.sqlWhereEntityWrapper(table);
    }

    protected String sqlWhereByMap(TableInfo table) {
        if (table.isLogicDelete()) {
            StringBuilder where = new StringBuilder();
            where.append("\n<where>");
            where.append("\n<if test=\"cm!=null and !cm.isEmpty\">");
            where.append("\n<foreach collection=\"cm.keys\" item=\"k\" separator=\"AND\">");
            where.append("\n<if test=\"cm[k] != null\">");
            where.append(SqlReservedWords.convert((GlobalConfiguration)this.getGlobalConfig(), (String)"\n${k}")).append(" = #{cm[${k}]}");
            where.append("</if>");
            where.append("\n</foreach>");
            where.append("\n</if>");
            where.append("\n").append(this.getLogicDeleteSql(table));
            where.append("\n</where>");
            return where.toString();
        }
        return super.sqlWhereByMap(table);
    }
}

