/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions.query;

import com.baomidou.mybatisplus.core.conditions.AbstractLambdaWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.baomidou.mybatisplus.core.toolkit.support.Property;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class LambdaQueryWrapper<T>
extends AbstractLambdaWrapper<T, LambdaQueryWrapper<T>>
implements Serializable {
    private List<String> sqlSelect = new ArrayList<String>();

    LambdaQueryWrapper(T entity, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments) {
        this.entity = entity;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
    }

    @Override
    public String getSqlSelect() {
        if (CollectionUtils.isEmpty(this.sqlSelect)) {
            return null;
        }
        return SqlUtils.stripSqlInjection(this.sqlSelect.stream().collect(Collectors.joining(",")));
    }

    @SafeVarargs
    public final LambdaQueryWrapper<T> select(Property<T, ?> ... columns) {
        for (Property<T, ?> column : columns) {
            this.sqlSelect.add(this.columnToString(column));
        }
        return (LambdaQueryWrapper)this.typedThis;
    }

    @Override
    protected LambdaQueryWrapper<T> instance(AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs) {
        return new LambdaQueryWrapper<Object>(this.entity, paramNameSeq, paramNameValuePairs, new MergeSegments());
    }
}

