/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.Property;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class LambdaUtils {
    private static final Map<String, Map<String, String>> LAMBDA_CACHE = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Map<Class, WeakReference<SerializedLambda>> FUNC_CACHE = new ConcurrentHashMap<Class, WeakReference<SerializedLambda>>();

    public static <T> SerializedLambda resolve(Property<T, ?> func) {
        Class<?> clazz = func.getClass();
        return Optional.ofNullable(FUNC_CACHE.get(clazz)).map(Reference::get).orElseGet(() -> {
            SerializedLambda lambda = SerializedLambda.convert(func);
            FUNC_CACHE.put(clazz, new WeakReference<SerializedLambda>(lambda));
            return lambda;
        });
    }

    public static void createCache(Class clazz, TableInfo tableInfo) {
        LAMBDA_CACHE.put(clazz.getName(), LambdaUtils.createLambdaMap(tableInfo, clazz));
    }

    private static void saveCache(String className, String property, String column) {
        Map<String, String> cacheMap = LAMBDA_CACHE.get(className);
        if (cacheMap == null) {
            cacheMap = new HashMap<String, String>();
        }
        cacheMap.put(property, column);
        LAMBDA_CACHE.put(className, cacheMap);
    }

    private static Map<String, String> createLambdaMap(TableInfo tableInfo, Class clazz) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (StringUtils.isNotEmpty(tableInfo.getKeyProperty())) {
            if (tableInfo.getParentClass() != clazz) {
                LambdaUtils.saveCache(tableInfo.getParentClass().getName(), tableInfo.getKeyProperty(), tableInfo.getKeyColumn());
            }
            map.put(tableInfo.getKeyProperty(), tableInfo.getKeyColumn());
        }
        tableInfo.getFieldList().forEach(i -> {
            if (i.getParentClass() != clazz) {
                LambdaUtils.saveCache(i.getParentClass().getName(), i.getProperty(), i.getColumn());
            }
            map.put(i.getProperty(), i.getColumn());
        });
        return map;
    }

    public static Map<String, String> getColumnMap(String entityClassName) {
        return LAMBDA_CACHE.get(entityClassName);
    }
}

