/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions.query;

import com.baomidou.mybatisplus.core.conditions.AbstractLambdaWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.baomidou.mybatisplus.core.toolkit.support.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class LambdaQueryWrapper<T>
extends AbstractLambdaWrapper<T, LambdaQueryWrapper<T>> {
    private List<String> queryColumn = new ArrayList<String>();
    private List<String> excludeColumn = new ArrayList<String>();

    LambdaQueryWrapper(T entity, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments) {
        this.entity = entity;
        if (entity != null) {
            this.entityClass = entity.getClass();
        }
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
    }

    @Override
    public String getSqlSelect() {
        if (CollectionUtils.isEmpty(this.queryColumn)) {
            if (this.entityClass != null) {
                this.queryColumn = Arrays.asList(TableInfoHelper.getTableColumns(this.entityClass, this.excludeColumn.toArray(new String[0])));
            }
        } else {
            return SqlUtils.stripSqlInjection(this.queryColumn.stream().filter(i -> !this.excludeColumn.contains(i)).collect(Collectors.joining(",")));
        }
        return CollectionUtils.isEmpty(this.queryColumn) ? null : String.join((CharSequence)",", this.queryColumn);
    }

    @SafeVarargs
    public final LambdaQueryWrapper<T> select(Property<T, ?> ... columns) {
        for (Property<T, ?> column : columns) {
            this.queryColumn.add(this.columnToString(column));
        }
        return (LambdaQueryWrapper)this.typedThis;
    }

    @SafeVarargs
    public final LambdaQueryWrapper<T> excludeColumns(Class<T> entityClass, Property<T, ?> ... excludeColumns) {
        Assert.notNull(entityClass, "entityClass is not null");
        Assert.notEmpty(excludeColumns, "excludeColumns is not empty");
        this.entityClass = entityClass;
        for (Property<T, ?> column : excludeColumns) {
            this.excludeColumn.add(this.columnToString(column));
        }
        return (LambdaQueryWrapper)this.typedThis;
    }

    @SafeVarargs
    public final LambdaQueryWrapper<T> excludeColumns(Property<T, ?> ... excludeColumns) {
        Assert.notNull(this.entity, "entity is not null");
        return this.excludeColumns(this.entity.getClass(), excludeColumns);
    }

    @Override
    protected LambdaQueryWrapper<T> instance(AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs) {
        return new LambdaQueryWrapper<Object>(this.entity, paramNameSeq, paramNameValuePairs, new MergeSegments());
    }
}

