/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.injector;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.parser.SqlParserHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public abstract class AbstractMethod {
    protected Configuration configuration;
    protected LanguageDriver languageDriver;
    protected MapperBuilderAssistant builderAssistant;

    public void inject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        this.configuration = builderAssistant.getConfiguration();
        this.builderAssistant = builderAssistant;
        this.languageDriver = this.configuration.getDefaultScriptingLanguageInstance();
        Class<?> modelClass = this.extractModelClass(mapperClass);
        if (null != modelClass) {
            if (this.getGlobalConfig().isSqlParserCache()) {
                SqlParserHelper.initSqlParserInfoCache(mapperClass);
            }
            TableInfo tableInfo = TableInfoHelper.initTableInfo(builderAssistant, modelClass);
            this.injectMappedStatement(mapperClass, modelClass, tableInfo);
        }
    }

    protected Class<?> extractModelClass(Class<?> mapperClass) {
        Type[] types = mapperClass.getGenericInterfaces();
        ParameterizedType target = null;
        for (Type type : types) {
            Object t;
            Object[] objectArray;
            int n;
            int n2;
            if (!(type instanceof ParameterizedType)) continue;
            Object[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            if (!ArrayUtils.isNotEmpty(typeArray) || (n2 = 0) >= (n = (objectArray = typeArray).length) || (t = objectArray[n2]) instanceof TypeVariable || t instanceof WildcardType) break;
            target = (ParameterizedType)type;
            break;
        }
        return target == null ? null : (Class)target.getActualTypeArguments()[0];
    }

    private boolean hasMappedStatement(String mappedStatement) {
        return this.configuration.hasStatement(mappedStatement, false);
    }

    protected String sqlSet(boolean logic, boolean ew, TableInfo table, String prefix) {
        StringBuilder set = new StringBuilder();
        set.append("<trim prefix=\"SET\" suffixOverrides=\",\">");
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            boolean ifTag;
            if (logic && fieldInfo.isLogicDelete()) {
                if (null != prefix) continue;
                set.append(fieldInfo.getColumn()).append("=");
                if (StringUtils.isCharSequence(fieldInfo.getPropertyType()).booleanValue()) {
                    set.append("'").append(fieldInfo.getLogicDeleteValue()).append("',");
                    continue;
                }
                set.append(fieldInfo.getLogicDeleteValue()).append(",");
                continue;
            }
            boolean bl = ifTag = FieldFill.UPDATE != fieldInfo.getFieldFill() && FieldFill.INSERT_UPDATE != fieldInfo.getFieldFill();
            if (ifTag) {
                if (StringUtils.isNotEmpty(fieldInfo.getUpdate())) {
                    set.append(fieldInfo.getColumn()).append("=").append(String.format(fieldInfo.getUpdate(), fieldInfo.getColumn())).append(",");
                    continue;
                }
                set.append(this.convertIfTag(true, fieldInfo, prefix, false)).append(fieldInfo.getColumn()).append("=#{");
                if (null != prefix) {
                    set.append(prefix);
                }
                set.append(fieldInfo.getEl()).append("},").append(this.convertIfTag(true, fieldInfo, null, true));
                continue;
            }
            set.append(fieldInfo.getColumn()).append("=#{");
            if (null != prefix) {
                set.append(prefix);
            }
            set.append(fieldInfo.getEl()).append("},");
        }
        if (ew) {
            set.append("<if test=\"ew != null and ew.sqlSet != null\">${ew.sqlSet}</if>");
        }
        set.append("</trim>");
        return set.toString();
    }

    protected String sqlWordConvert(DbType dbType, String val, boolean isColumn) {
        if (dbType == DbType.POSTGRE_SQL) {
            if (isColumn && val.toLowerCase().equals(val)) {
                return val;
            }
            return String.format("\"%s\"", val);
        }
        return val;
    }

    protected String joinStr(String ... strings) {
        return StringUtils.appends(null, strings);
    }

    protected String sqlSelectColumns(TableInfo table, boolean entityWrapper) {
        StringBuilder columns = new StringBuilder();
        DbType dbType = table.getDbType();
        if (null != table.getResultMap()) {
            if (entityWrapper) {
                columns.append("<choose><when test=\"ew != null and ew.sqlSelect != null\">${ew.sqlSelect}</when><otherwise>");
            }
            columns.append("*");
            if (entityWrapper) {
                columns.append("</otherwise></choose>");
            }
        } else {
            if (entityWrapper) {
                columns.append("<choose><when test=\"ew != null and ew.sqlSelect != null\">${ew.sqlSelect}</when><otherwise>");
            }
            List<TableFieldInfo> fieldList = table.getFieldList();
            int size = 0;
            if (null != fieldList) {
                size = fieldList.size();
            }
            if (StringUtils.isNotEmpty(table.getKeyProperty())) {
                if (table.isKeyRelated()) {
                    columns.append(this.sqlWordConvert(dbType, table.getKeyColumn(), true)).append(" AS ").append(this.sqlWordConvert(dbType, table.getKeyProperty(), false));
                } else {
                    columns.append(this.sqlWordConvert(dbType, table.getKeyColumn(), true));
                }
                if (size >= 1) {
                    columns.append(",");
                }
            }
            if (size >= 1) {
                columns.append(fieldList.stream().map(i -> {
                    String v = this.sqlWordConvert(dbType, i.getColumn(), true);
                    if (i.isRelated()) {
                        v = v + " AS " + this.sqlWordConvert(dbType, i.getProperty(), false);
                    }
                    return v;
                }).collect(Collectors.joining(",")));
            }
            if (entityWrapper) {
                columns.append("</otherwise></choose>");
            }
        }
        return columns.toString();
    }

    protected String sqlSelectObjsColumns(TableInfo table) {
        StringBuilder columns = new StringBuilder();
        DbType dbType = table.getDbType();
        columns.append("<choose><when test=\"ew != null and ew.sqlSelect != null\">${ew.sqlSelect}</when><otherwise>");
        if (StringUtils.isNotEmpty(table.getKeyProperty())) {
            if (table.isKeyRelated()) {
                columns.append(this.sqlWordConvert(dbType, table.getKeyColumn(), true)).append(" AS ").append(this.sqlWordConvert(dbType, table.getKeyProperty(), false));
            } else {
                columns.append(this.sqlWordConvert(dbType, table.getKeyColumn(), true));
            }
        } else {
            List<TableFieldInfo> fieldList = table.getFieldList();
            if (CollectionUtils.isNotEmpty(fieldList)) {
                TableFieldInfo fieldInfo = fieldList.get(0);
                String wordConvert = this.sqlWordConvert(dbType, fieldInfo.getProperty(), false);
                if (fieldInfo.getColumn().equals(wordConvert)) {
                    columns.append(wordConvert);
                } else {
                    columns.append(this.sqlWordConvert(dbType, fieldInfo.getColumn(), true)).append(" AS ").append(wordConvert);
                }
            }
        }
        columns.append("</otherwise></choose>");
        return columns.toString();
    }

    protected String sqlWhereByMap(TableInfo table) {
        return "<if test=\"cm!=null and !cm.isEmpty\"><where><foreach collection=\"cm\" index=\"k\" item=\"v\" separator=\"AND\"><choose><when test=\"v==null\"> ${k} IS NULL </when><otherwise> ${k}=#{v} </otherwise></choose></foreach></where></if>";
    }

    protected String convertIfTag(boolean ignored, TableFieldInfo fieldInfo, String prefix, boolean close) {
        FieldStrategy fieldStrategy = fieldInfo.getFieldStrategy();
        if (fieldStrategy == FieldStrategy.IGNORED) {
            if (ignored) {
                return "";
            }
            fieldStrategy = this.getGlobalConfig().getDbConfig().getFieldStrategy();
        }
        if (close) {
            return "</if>";
        }
        String property = fieldInfo.getProperty();
        Class<?> propertyType = fieldInfo.getPropertyType();
        property = StringUtils.removeIsPrefixIfBoolean(property, propertyType);
        if (null != prefix) {
            property = prefix + property;
        }
        if (fieldStrategy == FieldStrategy.NOT_EMPTY) {
            if (StringUtils.isCharSequence(propertyType).booleanValue()) {
                return String.format("<if test=\"%s!=null and %s!=''\">", property, property);
            }
            return String.format("<if test=\"%s!=null \">", property);
        }
        return String.format("<if test=\"%s!=null\">", property);
    }

    protected String convertIfTagIgnored(TableFieldInfo fieldInfo, boolean close) {
        return this.convertIfTag(true, fieldInfo, null, close);
    }

    protected String convertIfTag(TableFieldInfo fieldInfo, String prefix, boolean close) {
        return this.convertIfTag(false, fieldInfo, prefix, close);
    }

    protected String convertIfTag(TableFieldInfo fieldInfo, boolean close) {
        return this.convertIfTag(fieldInfo, null, close);
    }

    protected String sqlCondition(String condition, String column, String property) {
        return String.format(condition, column, property);
    }

    protected String sqlWhereEntityWrapper(TableInfo table) {
        StringBuilder where = new StringBuilder(128);
        where.append("<if test=\"ew!=null and !ew.emptyOfWhere\">");
        where.append("<trim prefix=\"WHERE\" prefixOverrides=\"AND|OR\">");
        where.append("<if test=\"ew.entity!=null\">");
        if (StringUtils.isNotEmpty(table.getKeyProperty())) {
            where.append("<if test=\"ew.entity.").append(table.getKeyProperty()).append("!=null\">");
            where.append(table.getKeyColumn()).append("=#{ew.entity.").append(table.getKeyProperty()).append("}");
            where.append("</if>");
        }
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            where.append(this.convertIfTag(fieldInfo, "ew.entity.", false));
            where.append(" AND ").append(this.sqlCondition(fieldInfo.getCondition(), fieldInfo.getColumn(), "ew.entity." + fieldInfo.getEl()));
            where.append(this.convertIfTag(fieldInfo, true));
        }
        where.append("</if>");
        where.append("<if test=\"ew.sqlSegment!=null and ew.sqlSegment!=''\"> AND ${ew.sqlSegment}</if>");
        where.append("</trim>");
        where.append("</if>");
        return where.toString();
    }

    protected MappedStatement addSelectMappedStatement(Class<?> mapperClass, String id, SqlSource sqlSource, Class<?> resultType, TableInfo table) {
        String resultMap;
        if (null != table && null != (resultMap = table.getResultMap())) {
            return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.SELECT, null, resultMap, null, (KeyGenerator)new NoKeyGenerator(), null, null);
        }
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.SELECT, null, null, resultType, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    protected MappedStatement addInsertMappedStatement(Class<?> mapperClass, Class<?> modelClass, String id, SqlSource sqlSource, KeyGenerator keyGenerator, String keyProperty, String keyColumn) {
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.INSERT, modelClass, null, Integer.class, keyGenerator, keyProperty, keyColumn);
    }

    protected MappedStatement addDeleteMappedStatement(Class<?> mapperClass, String id, SqlSource sqlSource) {
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.DELETE, null, null, Integer.class, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    public MappedStatement addUpdateMappedStatement(Class<?> mapperClass, Class<?> modelClass, String id, SqlSource sqlSource) {
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.UPDATE, modelClass, null, Integer.class, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    protected MappedStatement addMappedStatement(Class<?> mapperClass, String id, SqlSource sqlSource, SqlCommandType sqlCommandType, Class<?> parameterClass, String resultMap, Class<?> resultType, KeyGenerator keyGenerator, String keyProperty, String keyColumn) {
        String statementName = mapperClass.getName() + "." + id;
        if (this.hasMappedStatement(statementName)) {
            System.err.println("{" + statementName + "} Has been loaded by XML or SqlProvider, ignoring the injection of the SQL.");
            return null;
        }
        boolean isSelect = false;
        if (sqlCommandType == SqlCommandType.SELECT) {
            isSelect = true;
        }
        return this.builderAssistant.addMappedStatement(id, sqlSource, StatementType.PREPARED, sqlCommandType, null, null, null, parameterClass, resultMap, resultType, null, !isSelect, isSelect, false, keyGenerator, keyProperty, keyColumn, this.configuration.getDatabaseId(), this.languageDriver, null);
    }

    protected GlobalConfig getGlobalConfig() {
        return GlobalConfigUtils.getGlobalConfig(this.configuration);
    }

    public abstract MappedStatement injectMappedStatement(Class<?> var1, Class<?> var2, TableInfo var3);
}

