/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import java.lang.reflect.Field;

public class TableFieldInfo {
    private boolean related = false;
    private String column;
    private String property;
    private String el;
    private Class<?> propertyType;
    private FieldStrategy fieldStrategy;
    private String logicDeleteValue;
    private String logicNotDeleteValue;
    private String update;
    private String condition = "%s=#{%s}";
    private FieldFill fieldFill = FieldFill.DEFAULT;
    private Class<?> clazz;

    public TableFieldInfo(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, String column, String el, TableField tableField) {
        this.property = field.getName();
        this.propertyType = field.getType();
        this.fieldFill = tableField.fill();
        this.clazz = field.getDeclaringClass();
        this.update = tableField.update();
        this.el = el;
        tableInfo.setLogicDelete(this.initLogicDelete(dbConfig, field));
        if (StringUtils.isEmpty(tableField.value()) && dbConfig.isColumnUnderline()) {
            column = StringUtils.camelToUnderline(column);
        }
        this.column = column;
        this.related = TableInfoHelper.checkRelated(dbConfig.isColumnUnderline(), this.property, this.column);
        this.fieldStrategy = dbConfig.getFieldStrategy() != tableField.strategy() ? tableField.strategy() : dbConfig.getFieldStrategy();
        if (StringUtils.isNotEmpty(tableField.condition())) {
            this.condition = tableField.condition();
        } else {
            this.setCondition(dbConfig);
        }
    }

    public TableFieldInfo(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field) {
        this.property = field.getName();
        this.el = field.getName();
        this.fieldStrategy = dbConfig.getFieldStrategy();
        this.propertyType = field.getType();
        this.setCondition(dbConfig);
        this.clazz = field.getDeclaringClass();
        tableInfo.setLogicDelete(this.initLogicDelete(dbConfig, field));
        String column = field.getName();
        if (dbConfig.isColumnUnderline()) {
            column = StringUtils.camelToUnderline(column);
        }
        if (dbConfig.isCapitalMode()) {
            column = column.toUpperCase();
        }
        this.column = column;
        this.related = TableInfoHelper.checkRelated(dbConfig.isColumnUnderline(), this.property, this.column);
    }

    private boolean initLogicDelete(GlobalConfig.DbConfig dbConfig, Field field) {
        if (null == dbConfig.getLogicDeleteValue()) {
            return false;
        }
        TableLogic tableLogic = field.getAnnotation(TableLogic.class);
        if (null != tableLogic) {
            this.logicNotDeleteValue = StringUtils.isNotEmpty(tableLogic.value()) ? tableLogic.value() : dbConfig.getLogicNotDeleteValue();
            this.logicDeleteValue = StringUtils.isNotEmpty(tableLogic.delval()) ? tableLogic.delval() : dbConfig.getLogicDeleteValue();
            return true;
        }
        return false;
    }

    public boolean isRelated() {
        return this.related;
    }

    public boolean isLogicDelete() {
        return StringUtils.isNotEmpty(this.logicDeleteValue);
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setCondition(GlobalConfig.DbConfig dbConfig) {
        if ((null == this.condition || "%s=#{%s}".equals(this.condition)) && dbConfig.isColumnLike() && StringUtils.isCharSequence(this.propertyType).booleanValue()) {
            this.condition = dbConfig.getDbType().getLike();
        }
    }

    public String getColumn() {
        return this.column;
    }

    public String getProperty() {
        return this.property;
    }

    public String getEl() {
        return this.el;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public FieldStrategy getFieldStrategy() {
        return this.fieldStrategy;
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public String getUpdate() {
        return this.update;
    }

    public String getCondition() {
        return this.condition;
    }

    public FieldFill getFieldFill() {
        return this.fieldFill;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public TableFieldInfo setRelated(boolean related) {
        this.related = related;
        return this;
    }

    public TableFieldInfo setColumn(String column) {
        this.column = column;
        return this;
    }

    public TableFieldInfo setProperty(String property) {
        this.property = property;
        return this;
    }

    public TableFieldInfo setEl(String el) {
        this.el = el;
        return this;
    }

    public TableFieldInfo setPropertyType(Class<?> propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    public TableFieldInfo setFieldStrategy(FieldStrategy fieldStrategy) {
        this.fieldStrategy = fieldStrategy;
        return this;
    }

    public TableFieldInfo setLogicDeleteValue(String logicDeleteValue) {
        this.logicDeleteValue = logicDeleteValue;
        return this;
    }

    public TableFieldInfo setLogicNotDeleteValue(String logicNotDeleteValue) {
        this.logicNotDeleteValue = logicNotDeleteValue;
        return this;
    }

    public TableFieldInfo setUpdate(String update) {
        this.update = update;
        return this;
    }

    public TableFieldInfo setFieldFill(FieldFill fieldFill) {
        this.fieldFill = fieldFill;
        return this;
    }

    public TableFieldInfo setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableFieldInfo)) {
            return false;
        }
        TableFieldInfo other = (TableFieldInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRelated() != other.isRelated()) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        String this$el = this.getEl();
        String other$el = other.getEl();
        if (this$el == null ? other$el != null : !this$el.equals(other$el)) {
            return false;
        }
        Class<?> this$propertyType = this.getPropertyType();
        Class<?> other$propertyType = other.getPropertyType();
        if (this$propertyType == null ? other$propertyType != null : !this$propertyType.equals(other$propertyType)) {
            return false;
        }
        FieldStrategy this$fieldStrategy = this.getFieldStrategy();
        FieldStrategy other$fieldStrategy = other.getFieldStrategy();
        if (this$fieldStrategy == null ? other$fieldStrategy != null : !this$fieldStrategy.equals(other$fieldStrategy)) {
            return false;
        }
        String this$logicDeleteValue = this.getLogicDeleteValue();
        String other$logicDeleteValue = other.getLogicDeleteValue();
        if (this$logicDeleteValue == null ? other$logicDeleteValue != null : !this$logicDeleteValue.equals(other$logicDeleteValue)) {
            return false;
        }
        String this$logicNotDeleteValue = this.getLogicNotDeleteValue();
        String other$logicNotDeleteValue = other.getLogicNotDeleteValue();
        if (this$logicNotDeleteValue == null ? other$logicNotDeleteValue != null : !this$logicNotDeleteValue.equals(other$logicNotDeleteValue)) {
            return false;
        }
        String this$update = this.getUpdate();
        String other$update = other.getUpdate();
        if (this$update == null ? other$update != null : !this$update.equals(other$update)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        FieldFill this$fieldFill = this.getFieldFill();
        FieldFill other$fieldFill = other.getFieldFill();
        if (this$fieldFill == null ? other$fieldFill != null : !this$fieldFill.equals(other$fieldFill)) {
            return false;
        }
        Class<?> this$clazz = this.getClazz();
        Class<?> other$clazz = other.getClazz();
        return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableFieldInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRelated() ? 79 : 97);
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        String $el = this.getEl();
        result = result * 59 + ($el == null ? 43 : $el.hashCode());
        Class<?> $propertyType = this.getPropertyType();
        result = result * 59 + ($propertyType == null ? 43 : $propertyType.hashCode());
        FieldStrategy $fieldStrategy = this.getFieldStrategy();
        result = result * 59 + ($fieldStrategy == null ? 43 : $fieldStrategy.hashCode());
        String $logicDeleteValue = this.getLogicDeleteValue();
        result = result * 59 + ($logicDeleteValue == null ? 43 : $logicDeleteValue.hashCode());
        String $logicNotDeleteValue = this.getLogicNotDeleteValue();
        result = result * 59 + ($logicNotDeleteValue == null ? 43 : $logicNotDeleteValue.hashCode());
        String $update = this.getUpdate();
        result = result * 59 + ($update == null ? 43 : $update.hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        FieldFill $fieldFill = this.getFieldFill();
        result = result * 59 + ($fieldFill == null ? 43 : $fieldFill.hashCode());
        Class<?> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        return result;
    }

    public String toString() {
        return "TableFieldInfo(related=" + this.isRelated() + ", column=" + this.getColumn() + ", property=" + this.getProperty() + ", el=" + this.getEl() + ", propertyType=" + this.getPropertyType() + ", fieldStrategy=" + this.getFieldStrategy() + ", logicDeleteValue=" + this.getLogicDeleteValue() + ", logicNotDeleteValue=" + this.getLogicNotDeleteValue() + ", update=" + this.getUpdate() + ", condition=" + this.getCondition() + ", fieldFill=" + this.getFieldFill() + ", clazz=" + this.getClazz() + ")";
    }
}

