/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import java.util.List;
import org.apache.ibatis.session.Configuration;

public class TableInfo {
    private IdType idType = IdType.NONE;
    private DbType dbType;
    private String tableName;
    private String resultMap;
    private boolean keyRelated = false;
    private String keyProperty;
    private String keyColumn;
    private KeySequence keySequence;
    private List<TableFieldInfo> fieldList;
    private String currentNamespace;
    private String configMark;
    private boolean logicDelete = false;
    private Class<?> clazz;

    public String getSqlStatement(String sqlMethod) {
        return this.currentNamespace + "." + sqlMethod;
    }

    public void setFieldList(GlobalConfig globalConfig, List<TableFieldInfo> fieldList) {
        this.fieldList = fieldList;
        if (null != globalConfig.getDbConfig().getLogicDeleteValue()) {
            for (TableFieldInfo tfi : fieldList) {
                if (!tfi.isLogicDelete()) continue;
                this.setLogicDelete(true);
                break;
            }
        }
    }

    public void setFieldList(List<TableFieldInfo> fieldList) {
        throw ExceptionUtils.mpe("you can't use this method to set fieldList !");
    }

    public void setConfigMark(Configuration configuration) {
        Assert.notNull(configuration, "Error: You need Initialize MybatisConfiguration !");
        this.configMark = configuration.toString();
    }

    public boolean isLogicDelete() {
        return this.logicDelete;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getResultMap() {
        return this.resultMap;
    }

    public boolean isKeyRelated() {
        return this.keyRelated;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    public List<TableFieldInfo> getFieldList() {
        return this.fieldList;
    }

    public String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public String getConfigMark() {
        return this.configMark;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public TableInfo setIdType(IdType idType) {
        this.idType = idType;
        return this;
    }

    public TableInfo setDbType(DbType dbType) {
        this.dbType = dbType;
        return this;
    }

    public TableInfo setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableInfo setResultMap(String resultMap) {
        this.resultMap = resultMap;
        return this;
    }

    public TableInfo setKeyRelated(boolean keyRelated) {
        this.keyRelated = keyRelated;
        return this;
    }

    public TableInfo setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
        return this;
    }

    public TableInfo setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
        return this;
    }

    public TableInfo setKeySequence(KeySequence keySequence) {
        this.keySequence = keySequence;
        return this;
    }

    public TableInfo setCurrentNamespace(String currentNamespace) {
        this.currentNamespace = currentNamespace;
        return this;
    }

    public TableInfo setLogicDelete(boolean logicDelete) {
        this.logicDelete = logicDelete;
        return this;
    }

    public TableInfo setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableInfo)) {
            return false;
        }
        TableInfo other = (TableInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IdType this$idType = this.getIdType();
        IdType other$idType = other.getIdType();
        if (this$idType == null ? other$idType != null : !this$idType.equals(other$idType)) {
            return false;
        }
        DbType this$dbType = this.getDbType();
        DbType other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$resultMap = this.getResultMap();
        String other$resultMap = other.getResultMap();
        if (this$resultMap == null ? other$resultMap != null : !this$resultMap.equals(other$resultMap)) {
            return false;
        }
        if (this.isKeyRelated() != other.isKeyRelated()) {
            return false;
        }
        String this$keyProperty = this.getKeyProperty();
        String other$keyProperty = other.getKeyProperty();
        if (this$keyProperty == null ? other$keyProperty != null : !this$keyProperty.equals(other$keyProperty)) {
            return false;
        }
        String this$keyColumn = this.getKeyColumn();
        String other$keyColumn = other.getKeyColumn();
        if (this$keyColumn == null ? other$keyColumn != null : !this$keyColumn.equals(other$keyColumn)) {
            return false;
        }
        KeySequence this$keySequence = this.getKeySequence();
        KeySequence other$keySequence = other.getKeySequence();
        if (this$keySequence == null ? other$keySequence != null : !this$keySequence.equals(other$keySequence)) {
            return false;
        }
        List<TableFieldInfo> this$fieldList = this.getFieldList();
        List<TableFieldInfo> other$fieldList = other.getFieldList();
        if (this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList)) {
            return false;
        }
        String this$currentNamespace = this.getCurrentNamespace();
        String other$currentNamespace = other.getCurrentNamespace();
        if (this$currentNamespace == null ? other$currentNamespace != null : !this$currentNamespace.equals(other$currentNamespace)) {
            return false;
        }
        String this$configMark = this.getConfigMark();
        String other$configMark = other.getConfigMark();
        if (this$configMark == null ? other$configMark != null : !this$configMark.equals(other$configMark)) {
            return false;
        }
        if (this.isLogicDelete() != other.isLogicDelete()) {
            return false;
        }
        Class<?> this$clazz = this.getClazz();
        Class<?> other$clazz = other.getClazz();
        return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IdType $idType = this.getIdType();
        result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
        DbType $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $resultMap = this.getResultMap();
        result = result * 59 + ($resultMap == null ? 43 : $resultMap.hashCode());
        result = result * 59 + (this.isKeyRelated() ? 79 : 97);
        String $keyProperty = this.getKeyProperty();
        result = result * 59 + ($keyProperty == null ? 43 : $keyProperty.hashCode());
        String $keyColumn = this.getKeyColumn();
        result = result * 59 + ($keyColumn == null ? 43 : $keyColumn.hashCode());
        KeySequence $keySequence = this.getKeySequence();
        result = result * 59 + ($keySequence == null ? 43 : $keySequence.hashCode());
        List<TableFieldInfo> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        String $currentNamespace = this.getCurrentNamespace();
        result = result * 59 + ($currentNamespace == null ? 43 : $currentNamespace.hashCode());
        String $configMark = this.getConfigMark();
        result = result * 59 + ($configMark == null ? 43 : $configMark.hashCode());
        result = result * 59 + (this.isLogicDelete() ? 79 : 97);
        Class<?> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        return result;
    }

    public String toString() {
        return "TableInfo(idType=" + this.getIdType() + ", dbType=" + this.getDbType() + ", tableName=" + this.getTableName() + ", resultMap=" + this.getResultMap() + ", keyRelated=" + this.isKeyRelated() + ", keyProperty=" + this.getKeyProperty() + ", keyColumn=" + this.getKeyColumn() + ", keySequence=" + this.getKeySequence() + ", fieldList=" + this.getFieldList() + ", currentNamespace=" + this.getCurrentNamespace() + ", configMark=" + this.getConfigMark() + ", logicDelete=" + this.isLogicDelete() + ", clazz=" + this.getClazz() + ")";
    }
}

