/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.parser;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.parser.SqlParserInfo;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;

public class SqlParserHelper {
    public static final String DELEGATE_MAPPED_STATEMENT = "delegate.mappedStatement";
    private static final Map<String, SqlParserInfo> SQL_PARSER_INFO_CACHE = new ConcurrentHashMap<String, SqlParserInfo>();

    public static synchronized void initSqlParserInfoCache(Class<?> mapperClass) {
        Method[] methods;
        for (Method method : methods = mapperClass.getDeclaredMethods()) {
            SqlParser sqlParser = method.getAnnotation(SqlParser.class);
            if (null == sqlParser) continue;
            String sid = mapperClass.getName() + "." + method.getName();
            SQL_PARSER_INFO_CACHE.put(sid, new SqlParserInfo(sqlParser));
        }
    }

    public static SqlParserInfo getSqlParserInfo(MetaObject metaObject) {
        return SQL_PARSER_INFO_CACHE.get(SqlParserHelper.getMappedStatement(metaObject).getId());
    }

    public static MappedStatement getMappedStatement(MetaObject metaObject) {
        return (MappedStatement)metaObject.getValue(DELEGATE_MAPPED_STATEMENT);
    }
}

