/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.parser;

import com.baomidou.mybatisplus.annotation.SqlParser;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;

public class SqlParserHelper {
    public static final String DELEGATE_MAPPED_STATEMENT = "delegate.mappedStatement";
    private static final Map<String, Boolean> SQL_PARSER_INFO_CACHE = new ConcurrentHashMap<String, Boolean>();
    private static final Set<String> CACHE_INIT_MAPPER = new ConcurrentSkipListSet<String>();

    public static synchronized void initSqlParserInfoCache(Class<?> mapperClass) {
        Method[] methods;
        String mapperClassName = mapperClass.getName();
        if (CACHE_INIT_MAPPER.contains(mapperClassName)) {
            return;
        }
        for (Method method : methods = mapperClass.getDeclaredMethods()) {
            SqlParser sqlParser = method.getAnnotation(SqlParser.class);
            if (null == sqlParser) continue;
            String sid = mapperClassName + "." + method.getName();
            SQL_PARSER_INFO_CACHE.put(sid, sqlParser.filter());
        }
        CACHE_INIT_MAPPER.add(mapperClassName);
    }

    public static boolean getSqlParserInfo(MetaObject metaObject) {
        return SQL_PARSER_INFO_CACHE.getOrDefault(SqlParserHelper.getMappedStatement(metaObject).getId(), false);
    }

    public static MappedStatement getMappedStatement(MetaObject metaObject) {
        return (MappedStatement)metaObject.getValue(DELEGATE_MAPPED_STATEMENT);
    }
}

