/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import java.lang.reflect.Field;

public class TableFieldInfo {
    private boolean related;
    private boolean select = true;
    private String column;
    private String property;
    private String el;
    private Class<?> propertyType;
    private boolean isCharSequence;
    private FieldStrategy fieldStrategy;
    private String logicDeleteValue;
    private String logicNotDeleteValue;
    private String update;
    private String condition = "%s=#{%s}";
    private FieldFill fieldFill = FieldFill.DEFAULT;
    private Class<?> clazz;
    private String sqlSelect;

    public TableFieldInfo(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, String column, String el, TableField tableField) {
        this.property = field.getName();
        this.propertyType = field.getType();
        this.isCharSequence = StringUtils.isCharSequence(this.propertyType);
        this.fieldFill = tableField.fill();
        this.clazz = field.getDeclaringClass();
        this.update = tableField.update();
        this.el = el;
        tableInfo.setLogicDelete(this.initLogicDelete(dbConfig, field));
        if (StringUtils.isEmpty(tableField.value()) && tableInfo.isUnderCamel()) {
            column = StringUtils.camelToUnderline(column);
        }
        this.column = column;
        this.related = TableInfoHelper.checkRelated(tableInfo.isUnderCamel(), this.property, this.column);
        this.fieldStrategy = dbConfig.getFieldStrategy() != tableField.strategy() ? tableField.strategy() : dbConfig.getFieldStrategy();
        if (StringUtils.isNotEmpty(tableField.condition())) {
            this.condition = tableField.condition();
        } else {
            this.setCondition(dbConfig);
        }
        this.select = tableField.select();
    }

    public TableFieldInfo(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field) {
        this.property = field.getName();
        this.propertyType = field.getType();
        this.isCharSequence = StringUtils.isCharSequence(this.propertyType);
        this.el = field.getName();
        this.fieldStrategy = dbConfig.getFieldStrategy();
        this.setCondition(dbConfig);
        this.clazz = field.getDeclaringClass();
        tableInfo.setLogicDelete(this.initLogicDelete(dbConfig, field));
        String column = field.getName();
        if (tableInfo.isUnderCamel()) {
            column = StringUtils.camelToUnderline(column);
        }
        if (dbConfig.isCapitalMode()) {
            column = column.toUpperCase();
        }
        this.column = column;
        this.related = TableInfoHelper.checkRelated(tableInfo.isUnderCamel(), this.property, this.column);
    }

    private boolean initLogicDelete(GlobalConfig.DbConfig dbConfig, Field field) {
        TableLogic tableLogic = field.getAnnotation(TableLogic.class);
        if (null != tableLogic) {
            this.logicNotDeleteValue = StringUtils.isNotEmpty(tableLogic.value()) ? tableLogic.value() : dbConfig.getLogicNotDeleteValue();
            this.logicDeleteValue = StringUtils.isNotEmpty(tableLogic.delval()) ? tableLogic.delval() : dbConfig.getLogicDeleteValue();
            return true;
        }
        return false;
    }

    public boolean isLogicDelete() {
        return StringUtils.isNotEmpty(this.logicDeleteValue);
    }

    private void setCondition(GlobalConfig.DbConfig dbConfig) {
        if ((null == this.condition || "%s=#{%s}".equals(this.condition)) && dbConfig.isColumnLike() && this.isCharSequence) {
            this.condition = dbConfig.getDbType().getLike();
        }
    }

    public String getSqlSelect(DbType dbType) {
        if (this.sqlSelect != null) {
            return this.sqlSelect;
        }
        this.sqlSelect = SqlUtils.sqlWordConvert(dbType, this.getColumn(), true);
        if (this.related) {
            this.sqlSelect = this.sqlSelect + " AS " + SqlUtils.sqlWordConvert(dbType, this.getProperty(), false);
        }
        return this.sqlSelect;
    }

    public String getInsertSqlProperty() {
        String sqlScript = SqlScriptUtils.safeParam(this.el) + ",";
        if (this.fieldFill == FieldFill.INSERT || this.fieldFill == FieldFill.INSERT_UPDATE) {
            return sqlScript;
        }
        return this.convertIf(sqlScript, this.property);
    }

    public String getInsertSqlColumn() {
        String sqlScript = this.column + ",";
        if (this.fieldFill == FieldFill.INSERT || this.fieldFill == FieldFill.INSERT_UPDATE) {
            return sqlScript;
        }
        return this.convertIf(sqlScript, this.property);
    }

    public String getSqlSet(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlSet = this.column + "=";
        sqlSet = StringUtils.isNotEmpty(this.update) ? sqlSet + String.format(this.update, this.column) : sqlSet + SqlScriptUtils.safeParam(newPrefix + this.el);
        sqlSet = sqlSet + ",";
        if (this.fieldFill == FieldFill.UPDATE || this.fieldFill == FieldFill.INSERT_UPDATE) {
            return sqlSet;
        }
        return this.convertIf(sqlSet, newPrefix + this.property);
    }

    public String getSqlWhere(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlScript = " AND " + String.format(this.condition, this.column, newPrefix + this.el);
        return this.convertIf(sqlScript, newPrefix + this.property);
    }

    private String convertIf(String sqlScript, String property) {
        if (this.fieldStrategy == FieldStrategy.IGNORED) {
            return sqlScript;
        }
        if (this.fieldStrategy == FieldStrategy.NOT_EMPTY && this.isCharSequence) {
            return SqlScriptUtils.convertIf(sqlScript, String.format("%s != null and %s != ''", property, property), false);
        }
        return SqlScriptUtils.convertIf(sqlScript, String.format("%s != null", property), false);
    }

    public boolean isRelated() {
        return this.related;
    }

    public boolean isSelect() {
        return this.select;
    }

    public String getColumn() {
        return this.column;
    }

    public String getProperty() {
        return this.property;
    }

    public String getEl() {
        return this.el;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public boolean isCharSequence() {
        return this.isCharSequence;
    }

    public FieldStrategy getFieldStrategy() {
        return this.fieldStrategy;
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public String getUpdate() {
        return this.update;
    }

    public String getCondition() {
        return this.condition;
    }

    public FieldFill getFieldFill() {
        return this.fieldFill;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }
}

