/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit.sql;

import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlFormatter;

public class SqlUtils {
    private static final SqlFormatter SQL_FORMATTER = new SqlFormatter();
    private static ISqlParser COUNT_SQL_PARSER = null;
    private static Class<ISqlParser> DEFAULT_CLASS = null;

    public static String getOriginalCountSql(String originalSql) {
        return String.format("SELECT COUNT(1) FROM ( %s ) TOTAL", originalSql);
    }

    public static SqlInfo getOptimizeCountSql(boolean optimizeCountSql, ISqlParser sqlParser, String originalSql) {
        if (!optimizeCountSql) {
            return SqlInfo.newInstance().setSql(SqlUtils.getOriginalCountSql(originalSql));
        }
        if (null == COUNT_SQL_PARSER) {
            if (null != sqlParser) {
                COUNT_SQL_PARSER = sqlParser;
            } else {
                try {
                    if (DEFAULT_CLASS == null) {
                        return SqlInfo.newInstance().setSql(SqlUtils.getOriginalCountSql(originalSql));
                    }
                    COUNT_SQL_PARSER = DEFAULT_CLASS.newInstance();
                }
                catch (Exception e) {
                    throw new MybatisPlusException(e);
                }
            }
        }
        return COUNT_SQL_PARSER.optimizeSql(null, originalSql);
    }

    public static String sqlFormat(String boundSql, boolean format) {
        if (format) {
            try {
                return SQL_FORMATTER.format(boundSql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boundSql;
    }

    public static String concatLike(String str, SqlLike type) {
        StringBuilder builder = new StringBuilder(str.length() + 3);
        switch (type) {
            case LEFT: {
                builder.append("%").append(str);
                break;
            }
            case RIGHT: {
                builder.append(str).append("%");
                break;
            }
            case CUSTOM: {
                builder.append(str);
                break;
            }
            default: {
                builder.append("%").append(str).append("%");
            }
        }
        return builder.toString();
    }

    public static String stripSqlInjection(String sql) {
        if (null == sql) {
            throw new MybatisPlusException("strip sql is null.");
        }
        return sql.replaceAll("('.+--)|(--)|(\\|)|(%7C)", "");
    }

    static {
        try {
            DEFAULT_CLASS = Class.forName("com.baomidou.mybatisplus.extension.plugins.pagination.optimize.JsqlParserCountOptimize");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

